;
; Computes rbar for each region, for instrumental data
;
; Define dimensions
;
yrst=1856
yren=1992
nyr=yren-yrst+1
nmon=12
;
; Get masks of boxes to use for each region
;
restore,filename='regboxes.idlsave'
;
; Convert to a list of grid-points
;
ntree=intarr(nreg)
for i = 0 , nreg-1 do begin
  fdmask=reform(boxlists(*,*,i),g.nx*g.ny)
  dummy=where(finite(fdmask),ndummy)
  ntree(i)=ndummy
endfor
maxbox=max(ntree)
treelist=fltarr(maxbox,nreg)
for i = 0 , nreg-1 do begin
  fdmask=reform(boxlists(*,*,i),g.nx*g.ny)
  dummy=where(finite(fdmask),ndummy)
  treelist(0:ntree(i)-1,i)=dummy(*)
endfor
;
; Read in monthly data and keep the groups of grid boxes only
;
densmon=fltarr(nyr,nmon,maxbox,nreg)
openr,1,'/cru/u2/f055/detect/obsdat/tair_monthly.dat'
for iyr = 0 , nyr-1 do begin
  for imon = 0 , nmon-1 do begin
    fd=rdtair(72,36,imon=im,iyr=iy,lun=1)
    fd=reform(fd,g.nx*g.ny)
    print,iyr,iy,imon,im
    for i = 0 , nreg-1 do begin
      densmon(iyr,imon,0:ntree(i)-1,i)=fd(treelist(0:ntree(i)-1,i))
    endfor
  endfor
endfor
close,1
;
; Convert to a long-season mean (just let it create divide by zero errors)
;
densann = total(densmon(*,3:8,*,*),2,/nan) / $
  float(total(finite(densmon(*,3:8,*,*)),2,/nan))
;
; Repeat for each region
;
allrbar=fltarr(nreg)
for i = 0 , nreg-1 do begin
  ;
  ; Extract number of chronologies and the timeseries
  ;
  print,'Doing region ',regname(i),' with ntree=',ntree(i)
  nsize=ntree(i)
  inx=densann(*,0:nsize-1,i)
  ;
  ; Define a correlation matrix
  ;
  grandr=fltarr(nsize,nsize)
  ;
  ; Do each tree against all others (including itself)
  ;
  for j = 0 , nsize-1 do begin
    print,j
    iny=reform(inx(*,j))
    rowr=manycorr(inx,iny,/nan,nval=nval)     ; compute r values
    grandr(*,j)=rowr(*)
  endfor
  ;
  ; Total it and average it, but only do i<>j.
  ;
  totr=0.
  totn=0.
  for j = 1 , nsize-1 do begin
    for k = 0 , j-1 do begin
      if finite(grandr(j,k)) then begin
        totr=totr+grandr(j,k)
        totn=totn+1.
        if grandr(j,k) eq 1. then message,'Ooops!'
      endif
    endfor
  endfor
  totr=totr/totn
  ;
  allrbar(i)=totr
  ;
endfor
;
save,filename='rbar_instr_full.idlsave',nreg,regname,allrbar
;
end
