;
; Computes lists of grid-boxes in each region
;
;----------------------------------------------------
;
; Get chronology locations
;
restore,filename='reglists.idlsave'
;
; Get IPCC instrumental dataset grid
;
g=def_grid(/ipcc)
;
; For each region, locate the grid-boxes with data in
;
boxlists=fltarr(g.nx,g.ny,nreg)
boxnumbs=fltarr(g.nx,g.ny,nreg)
for ireg = 0 , nreg-1 do begin
  statx=xlon(0:ntree(ireg)-1,ireg)
  staty=ylat(0:ntree(ireg)-1,ireg)
  statval=fltarr(ntree(ireg))+1.
  fdout=gridit(g.nx,g.ny,g.x,g.y,statx,staty,statval,nstat=nstat)
  boxlists(*,*,ireg)=fdout(*,*)
  boxnumbs(*,*,ireg)=nstat(*,*)
endfor
;
save,filename='regboxes.idlsave',nreg,boxlists,boxnumbs,regname,g
;
end
