;
; Plots mean of MXD cores for each species, according to age not year
;
; Prepare for plotting
;
loadct,39
multi_plot,nrow=4,ncol=2,layout='large'
if !d.name eq 'X' then begin
  window,ysize=850
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=9
endelse
def_1color,20,color='mgrey'
;
nspec=36
specname=strarr(nspec)
nyr=2000
onedat=fltarr(6,nyr)
;
openr,1,'mx.MXD.1400.sitegrow.dat'
;
for ispec = 0 , nspec-1 do begin
  ;
  onest=' '
  readf,1,onest
  specname(ispec)=onest
  readf,1,onedat
  ml=where(onedat eq 9990.,nmiss)
  if nmiss gt 0 then onedat(ml)=!values.f_nan
  ;
  print,onest,moment(onedat(1,20:99))
  ;
  maxcore=max(onedat(3,*),/nan)
  if maxcore gt 100 then begin
    ml=where(onedat(3,*) lt 10.,nmiss)
    if nmiss gt 0 then onedat(1,ml)=!values.f_nan
    pause
    plot,onedat(0,*),onedat(1,*),title=onest,$
      /xstyle,xrange=[0,600],xtitle='Age of tree',$
      /ystyle,yrange=[0,110],ytitle='Density or Ncore/10'
    oplot,onedat(0,*),onedat(1,*)+onedat(2,*)
    oplot,onedat(0,*),onedat(1,*)-onedat(2,*)
    !p.multi(0)=!p.multi(0)+1
    plot,onedat(0,*),onedat(3,*),thick=3,color=20,$
      xstyle=5,xrange=[0,600],ystyle=5,yrange=[0,1100]
  endif
  ;
endfor
;
close,1
;
end
