;
; Plots mean of MXD cores for each species, according to age not year
;
; Prepare for plotting
;
loadct,39
multi_plot,nrow=2
if !d.name eq 'X' then begin
  window,ysize=850
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,bold=0,font_size=12
endelse
def_1color,20,color='mdgrey'
!x.margin=[8,8]
;
nspec=36
specname=strarr(nspec)
nyr=2000
onedat=fltarr(6,nyr)
;
openr,1,'mx.MXD.1400.sitegrow.dat'
;
nspec=20
for ispec = 0 , nspec-1 do begin
  ;
  onest=' '
  readf,1,onest
  specname(ispec)=onest
  readf,1,onedat
  ;
  if onest eq 'PISY' then begin
    ml=where(onedat eq 9990.,nmiss)
    if nmiss gt 0 then onedat(ml)=!values.f_nan
    print,onest,moment(onedat(1,20:99))
    maxcore=max(onedat(3,*),/nan)
    ml=where(onedat(3,*) lt 10.,nmiss)
    if nmiss gt 0 then onedat(1,ml)=!values.f_nan
    plot,onedat(0,*),onedat(1,*)*0.01,thick=4,$
      /xstyle,xrange=[0,450],xtitle='Age of tree (yr)',$
      ystyle=5,yrange=[0,1]
    if !d.name eq 'PS' then device,oblique=1
    xyouts,220,0.9,'All Pinus sylvestris cores'
    if !d.name eq 'PS' then device,oblique=0
    oplot,onedat(0,*),0.01*(onedat(1,*)+onedat(2,*)),thick=2
    oplot,onedat(0,*),0.01*(onedat(1,*)-onedat(2,*)),thick=2
    axis,yaxis=0,/ystyle,ytitle='Maximum Latewood Density  (g cm!U-3!N)',$
      yticks=3,ytickv=[0.4,0.6,0.8,1.0],yminor=4
    !p.multi(0)=!p.multi(0)+1
    plot,onedat(0,*),onedat(3,*),thick=4,color=20,$
      xstyle=5,xrange=[0,450],ystyle=5,yrange=[0,1800]
    axis,yaxis=1,/ystyle,ytitle='Number of tree cores          ',$
      yticks=2,ytickv=[0,500,1000],yminor=5
  endif
  ;
endfor
;
close,1
;
end
