! rewritebounds.f90
! f90 -o rewritebounds filenames.f90 grimfiles.f90 execfiles.f90 rewritebounds.f90

program ReWriteBounds

use FileNames
use GrimFiles
use ExecFiles

implicit none

real, pointer, dimension (:,:,:)		:: Data

real, dimension (4)				:: OldBounds,NewBounds

integer, pointer, dimension (:,:)		:: Grid
integer, pointer, dimension (:)			:: YearAD

character (len=80), pointer, dimension (:) 	:: LoadFile,SaveFile,Subs

real, parameter :: MissVal = -999.0

integer :: ExecN, XExec, AllocStat, ReadStatus

character (len=80) :: Info
character (len= 4) :: CallSuffix,LoadSuffix,SaveSuffix

print*, "  > Enter the number of executions: "
do
	read (*,*,iostat=ReadStatus), ExecN
	if (ReadStatus.LE.0.AND.ExecN.GE.1) exit
end do

call GetExecFiles (ExecN,LoadFile,SaveFile,Subs)

NewBounds (1) = -11
NewBounds (2) =  32
NewBounds (3) =  34
NewBounds (4) =  72

do XExec = 1, ExecN
  print*, "  > Execution: ", XExec
  print*, "  > Loading..."
  call LoadGrim (Data,Grid,YearAD,OldBounds,Info,LoadFile(XExec),"    ",LoadSuffix)
  print*, "  > Saving..."
  call SaveGrim (Data,Grid,YearAD,NewBounds,Info,SaveFile(XExec),LoadSuffix,SaveSuffix)  
  deallocate (Data,Grid,YearAD)
end do

end program ReWriteBounds
