! makehires.f90
! f90 -o ./../grim/makehires time.f90 filenames.f90 grimfiles.f90 sortmod.f90 grid.f90 execfiles.f90 
!	regress.f90 interpol.f90 ./../grim/makehires.f90

program MakeHiRes

use Time
use FileNames
use GrimFiles
use SortMod
use Grid
use ExecFiles
use Regress
use Interpol

implicit none

real, dimension (4)				:: RefBounds
integer, pointer, dimension (:,:)		:: RefGrid
character (len=80), pointer, dimension (:)	:: ExecLoadFile,ExecSaveFile,ExecSubs

real, parameter :: MissVal = -999.0

real 			:: ExeMulti,WyeMulti
integer 		:: RefBoxN,ExecN,XExec,ReadStatus,Extent
character (len=80) 	:: ExecName

!*******************************************************************************

open  (99,file="/cru/u2/f709762/data/scratch/log-makehires.dat",status="replace",action="write")

print*
print*, "  > ***** MakeHiRes: transforms one grim into higher res grim *****"

print*
print*, "  > Determine the grid and domain to create by selecting a grim file:"
call GrabGrid (1,RefGrid,RefBounds,RefBoxN)

print*
print*, "  > Select a number of grim on which to operate."
call GetExecFiles (nint(MissVal),ExecLoadFile,ExecSaveFile,ExecSubs)
ExecN = size (ExecLoadFile)

print*				! e.g. for 0.5deg-->10min these are both 3.0
print*, "  > Identify the magnification ratios (long,lat): "
do
	read (*,*,iostat=ReadStatus), ExeMulti,WyeMulti
	if (ReadStatus.LE.0.AND.ExeMulti.GT.0.AND.WyeMulti.GT.0) exit
end do
    
print*				! e.g. 1
print*, "  > Enter the distance from a cell to the furthest OK cell to employ: "
do
	read (*,*,iostat=ReadStatus), Extent
	if (ReadStatus.LE.0.AND.Extent.GE.0) exit
end do
    
print*				! e.g. 'test'
print*, "  > Name the operation: "
do
	read (*,*,iostat=ReadStatus), ExecName
	if (ReadStatus.LE.0.AND.ExecName.NE."") exit
end do
    
do XExec = 1, ExecN
  print*
  print "(2a)", "   > ", trim(ExecSubs(XExec))
  call CrudeInterpol (ExecLoadFile(XExec),ExecSaveFile(XExec),&
  			ExeMulti,WyeMulti,Extent,RefGrid,RefBounds,ExecName)
end do

print*

close (99)

!*******************************************************************************

end program MakeHiRes
