! program written to load Mike Hulme RefGrids
! pgf90 -Mstandard -Minfo -fast -Mscalarsse -Mvect=sse -Mflushz 
! 	-o ./../grim/loadmikeh time.f90 filenames.f90 
!	grimfiles.f90 initialmod.f90 grid.f90 ./../grim/loadmikeh.f90

program LoadMikeH

use Time
use FileNames
use GrimFiles
use InitialMod
use Grid

implicit none

real,    pointer, dimension (:,:,:)		:: Data
real, dimension (4)				:: Bounds
integer, pointer, dimension (:,:)		:: RefGrid
integer, pointer, dimension (:)			:: YearAD
integer, dimension (12)				:: LineData

real, parameter :: MissVal = -999.0
real, parameter :: OrigMissVal = -10.0
real, parameter :: Multi = 0.1

integer :: ReadStatus,AllocStat,  YearAD0,YearAD1,Len,FileBox,Beg,End
integer :: NExe,NWye,NBox,NYear,NMonth,NLine,NEntry
integer :: XExe,XWye,XBox,XYear,XMonth,XLine,XEntry

character (len=80) :: LogfilePath,LoadFile,SaveFile,Info,GivenFile
character (len=04) :: Suffix,SaveSuffix

! ******************************************************************************

LogFilePath = '/tyn1/tim/scratch/log-loadmikeh.dat'
open (99,file=LogFilePath,status="replace",access="sequential",form="formatted",action="write")

print*, "  > Submit a grim that contains the appropriate RefGrid."
call GrabGrid (1,RefGrid,Bounds,NBox,Quiet=1)

NExe = size (RefGrid,1) ; NWye = size (RefGrid,2)

print*, "  > Enter the first, last years AD: "
do
	read (*,*,iostat=ReadStatus), YearAD0, YearAD1
	if (ReadStatus.LE.0.AND.YearAD1.GE.YearAD0) exit
end do
NYear  = YearAD1 - YearAD0 + 1 ; NMonth = 12

print*, "  > Select the file to load: "
do
	read (*,*,iostat=ReadStatus), GivenFile
	if (ReadStatus.LE.0.AND.GivenFile.NE."") exit
end do
LoadFile = LoadPath (GivenFile,"    ")

print*, "  > Select the file to save: "
do
	read (*,*,iostat=ReadStatus), GivenFile
	if (ReadStatus.LE.0.AND.GivenFile.NE."") exit
end do
SaveFile = SavePath (GivenFile,"    ")
Len=len_trim(SaveFile) ; Suffix=SaveFile((Len-3):Len)

print*, "  > Enter the information line: "
do
	read (*,*,iostat=ReadStatus), Info
	if (ReadStatus.LE.0.AND.Info.NE."") exit
end do

allocate (Data(NYear,NMonth,NBox),YearAD(NYear), stat=AllocStat)
if (AllocStat.NE.0) print*, "  > ##### ERROR: alloc 1 #####"
Data=MissVal
do XYear=1,NYear
  YearAD(XYear)=YearAD0+XYear-1
end do

call system ('wc -l ' // LoadFile // ' > trashme-loadcts.txt')		! get number of lines
open  (3,file='trashme-loadcts.txt',status="old",access="sequential",form="formatted",action="read")
read  (3,"(i8)"), NLine
close (3)
call system ('rm trashme-loadcts.txt')

open (2,file=Loadfile,status="old",access="sequential",form="formatted",action="read")

XLine=0
do
  read  (2,"(i7,49x,2i4)"), FileBox,Beg,End
  XExe=mod(FileBox,NExe) ; XWye=nint(real(FileBox-XExe)/NExe)+1
  XBox=RefGrid(XExe,XWye)
  
  do XEntry=Beg,End
    XYear=XEntry-YearAD(1)+1
    read  (2,"(4x,12i5)"), (LineData(XMonth),XMonth=1,NMonth)
    Data(XYear,1:12,XBox) = LineData(1:12)
  end do
  
  XLine=XLine+End-Beg+2
  if (XLine.GE.NLine) exit
end do

where (Data.EQ.OrigMissVal) 	Data=MissVal
where (Data.NE.MissVal) 	Data=Data*Multi

call SaveGrim (Data,RefGrid,YearAD,Bounds,Info,SaveFile,Suffix,SaveSuffix,NoZip=1)

deallocate (Data,RefGrid,YearAD,stat=AllocStat)
if (AllocStat.NE.0) print*, "  > ##### ERROR: dealloc 1 #####"

close (99)

end program LoadMikeH
