program MakeScale

integer, allocatable, dimension (:) :: Red, Green, Blue

character (len=80) :: GloFilePath

integer :: XBlock, BlockN
integer :: AllocStat			! status of allocation statement
integer :: ReadStatus			! status of user input

BlockN = 255
allocate (Red(BlockN), Green(BlockN), Blue(BlockN), stat=AllocStat)
if (AllocStat.NE.0) print*, "  > ##### ERROR: MakeScale: Allocation failure #####"

do XBlock = 1, 5		! black
  Red   (XBlock) = 0
  Green (XBlock) = 0
  Blue  (XBlock) = 0
end do

do XBlock = 6, 58		! pink
  Red   (XBlock) = 252
  Green (XBlock) = 0
  Blue  (XBlock) = 191
end do

do XBlock = 59, 106		! white
  Red   (XBlock) = 255
  Green (XBlock) = 255
  Blue  (XBlock) = 255
end do

do XBlock = 107, 154		! green
  Red   (XBlock) = 0
  Green (XBlock) = 180
  Blue  (XBlock) = 0
end do

do XBlock = 155, 202		! white
  Red   (XBlock) = 255
  Green (XBlock) = 255
  Blue  (XBlock) = 255
end do

do XBlock = 203, 253		! pink
  Red   (XBlock) = 252
  Green (XBlock) = 0
  Blue  (XBlock) = 191
end do

do XBlock = 254, 255		! white
  Red   (XBlock) = 255
  Green (XBlock) = 255
  Blue  (XBlock) = 255
end do

GloFilePath = '/cru/u2/f709762/data/idlcolours/accuracy-block.dat'

open (2, file=GloFilePath, status="replace", access="sequential", form="formatted", action="write")

do XBlock = 1, BlockN
  write (2, fmt="(3i6)"), Red (XBlock), Green (XBlock), Blue (XBlock)
end do

close (2)

deallocate (Red, Green, Blue)

end program MakeScale

