! f90 -o convertelev initialmod.f90 savemod.f90 convertelev.f90

program ConvertElev

use InitialMod
use SaveMod

implicit none

real, dimension (:), pointer 			:: GloSlice

integer, pointer, dimension (:,:)		:: MapIDLRaw, MapIDLReg
integer, dimension (:), pointer 		:: MapRawReg, RegSizes

character (len=20), dimension (:), pointer 	:: RegNames

real, dimension (:), allocatable :: RawVec

integer :: XRawLat, XRawLong, XSix, XRaw, XLat, XLong, XDatum
integer :: Raw0, Raw1
integer :: LatN, LongN, GridChosen, GridDataN, RegN

character (len=80) :: GloFilePath, GridFilePath, RegTitle, Blank
character (len=10) :: GridTitle

Blank = ""

call GridSelect (GridChosen,GridTitle,LongN,LatN,GridDataN,GridFilePath)
call RegSelect  (GridChosen, LongN, LatN, GridDataN, MapIDLReg, RegSizes, RegNames, RegTitle, RegN)
call RawSelect  (GridChosen,LongN,LatN,MapIDLReg,MapIDLRaw,MapRawReg)

allocate (RawVec(GridDataN),GloSlice(RegN))

GloFilePath = '/cru/u2/f709762/goglo/ref/hadcm2-elev.txt'
open (2, file=GloFilePath, status="old", access="sequential", form="formatted", action="read")

do XRawLat = (LatN-1), 0, -1
  do XSix = 0, ((LongN/6)-1)
    Raw0 = (XRawLat*LongN) + (XSix*6) + 1
    Raw1 = (XRawLat*LongN) + (XSix*6) + 6
    read (2,"(6e12.5)"), (RawVec (XRaw), XRaw = Raw0,Raw1)
  end do
end do

do XDatum = 1, GridDataN
    GloSlice (MapRawReg(XDatum)) = RawVec (XDatum)
end do

close (2)

call SaveGlo (LongN, LatN, RegN, GridFilePath, Blank, Blank, GloSlice, MapIDLReg)

deallocate (RawVec,GloSlice,MapIDLReg,RegSizes,RegNames,MapIDLRaw,MapRawReg)

end program ConvertElev
