! f90 -o ./../goglo/calcke3 gridops.f90 ./../goglo/calcke3.f90

program CalcKe3

use GridOps

implicit none

integer, parameter :: nine = selected_real_kind (11,99)

real (kind=nine) :: LatDeg,LatMin,LatSec,LonDeg,LonMin,LonSec,East,North

integer :: ReadStatus,QWhichWay

open (99,file="/cru/u2/f709762/data/scratch/log-calcke2.dat",status="replace",action="write")

print*
print*, "  > Convert from (=1) or to (=2) lat/lon ? "
do
	read (*,*,iostat=ReadStatus), QWhichWay
	if (ReadStatus.LE.0.AND.QWhichWay.GE.1.AND.QWhichWay.LE.2) exit
end do

if (QWhichWay.EQ.1) then
  print*, "  > Enter the lat: deg,min,sec: "
  do
	read (*,*,iostat=ReadStatus), LatDeg, LatMin, LatSec
	if (ReadStatus.LE.0) exit
  end do

  print*, "  > Enter the lon: deg,min,sec: "
  do
	read (*,*,iostat=ReadStatus), LonDeg, LonMin, LonSec
	if (ReadStatus.LE.0) exit
  end do

  call LatLongToNatGrid (East,North,LatDeg,LatMin,LatSec,LonDeg,LonMin,LonSec)

  print "(a,2i)", "   > Easting, northing (metres): ", East,North
else
  print*, "  > Enter the northing, easting, in metres: "
  do
	read (*,*,iostat=ReadStatus), North, East
	if (ReadStatus.LE.0) exit
  end do
  
  call NatGridToLatLong (East,North,LatDeg,LonDeg)
  
  print "(a,2e16.5)", "   > Latitude, longitude (degrees): ", LatDeg, LonDeg 
end if

print*

close (99)

end program CalcKe3
