; Extend adds functionality specificially designed for contour plotting
;	it means that all subsequent relevant procedure calls must support model indices of 100+ 
;	give data arrays where the date-line column is replicated to form both the first and last columns
;	this enables contour plotting from -180 to 180
; ModelChosen must be defined and set, or set to -999

pro SelectModel, ModelChosen, ModelFilePath, ModelLongN, ModelLatN, Extend=Extend

ModelFilePath = "missing"
ModelTitle    = ""
ModelLongN    = 0L
ModelLatN     = 0L

ExitSelect = -1
while (ExitSelect NE 1) do begin
  if (ExitSelect NE -1 OR ModelChosen LT 1) then begin
    print, "  > Select a model (0=list): "	
    read, ModelChosen
  endif
  
  if (ModelChosen EQ 0) then begin
	print, "  >  1. obs (Hulme)	 2. ECHam4-OPYC3"
	print, "  >  3. HadCM2		 4. HadCM3"
	print, "  >  5. CGCM1		 6. CSIRO"
	print, "  >  7. CCSR-NIES	 8. ECHam3-LSG"
	print, "  >  9. GFDL		10. NCAR-CGCM"
	print, "  > 11. NCAR-PCM3	12. 0.5"
	print, "  > 13. 10' Europe	14. 0.5 Europe"
	print, "  > 15. 10' ATEAM       16. ReGrid x 2"
	print, "  > 17. 10' Britain     18. Richard Jones"
	print, "  > 19. h2grid=HadCM2   20. 5km NatGrid"	; all h2grid grim files are saved as H2 .glo
	print, "  > 21. 5km NG cut      22. 5.0 degrees"
	print, "  > 23. 2.5 degrees"
  endif else begin
    if            (ModelChosen GE 1   AND ModelChosen LE  23) then begin
      ExitSelect = 1
    endif else if (ModelChosen GE 101 AND ModelChosen LE 123) then begin
      ExitSelect = 1
    endif else begin
      print, "  > Model selection out of range. Retry."
      ExitSelect = 0
    endelse
  endelse
endwhile  
					; do not change this line !!!! cf. CheckGlo and elsewhere
if (keyword_set(Extend) AND ModelChosen LT 100) then ModelChosen = ModelChosen + 100

if (ModelChosen EQ 1)  then ModelFilePath = "/cru/tyn1/f709762/goglo/obshulme.ref"
if (ModelChosen EQ 2)  then ModelFilePath = "/cru/tyn1/f709762/goglo/echam4-opyc3.ref"
if (ModelChosen EQ 3)  then ModelFilePath = "/cru/tyn1/f709762/goglo/hadcm2.ref"
if (ModelChosen EQ 4)  then ModelFilePath = "/cru/tyn1/f709762/goglo/hadcm3.ref"
if (ModelChosen EQ 5)  then ModelFilePath = "/cru/tyn1/f709762/goglo/cgcm1.ref"
if (ModelChosen EQ 6)  then ModelFilePath = "/cru/tyn1/f709762/goglo/csiro.ref"
if (ModelChosen EQ 7)  then ModelFilePath = "/cru/tyn1/f709762/goglo/ccsr-nies.ref"
if (ModelChosen EQ 8)  then ModelFilePath = "/cru/tyn1/f709762/goglo/echam3-lsg.ref"
if (ModelChosen EQ 9)  then ModelFilePath = "/cru/tyn1/f709762/goglo/gfdl.ref"
if (ModelChosen EQ 10) then ModelFilePath = "/cru/tyn1/f709762/goglo/ncar-cgcm.ref"
if (ModelChosen EQ 11) then ModelFilePath = "/cru/tyn1/f709762/goglo/ncar-pcm3.ref"
if (ModelChosen EQ 12) then ModelFilePath = "/cru/tyn1/f709762/goglo/half-degree.ref"
if (ModelChosen EQ 13) then ModelFilePath = "/cru/tyn1/f709762/goglo/tenmin-euro.ref"
if (ModelChosen EQ 14) then ModelFilePath = "/cru/tyn1/f709762/goglo/half-degree-euro.ref"
if (ModelChosen EQ 15) then ModelFilePath = "/cru/tyn1/f709762/goglo/tenmin-ateam.ref"
if (ModelChosen EQ 16) then ModelFilePath = "/cru/tyn1/f709762/goglo/regridx2.ref"
if (ModelChosen EQ 17) then ModelFilePath = "/cru/tyn1/f709762/goglo/tenmin-brit.ref"
if (ModelChosen EQ 18) then ModelFilePath = "/cru/tyn1/f709762/goglo/richjones.ref"
if (ModelChosen EQ 19) then ModelFilePath = "/cru/tyn1/f709762/goglo/hadcm2.ref"
if (ModelChosen EQ 20) then ModelFilePath = "/cru/tyn1/f709762/goglo/ng5.ref"
if (ModelChosen EQ 21) then ModelFilePath = "/cru/tyn1/f709762/goglo/ng5cut.ref"
if (ModelChosen EQ 22) then ModelFilePath = "/cru/tyn1/f709762/goglo/five-degree.ref"
if (ModelChosen EQ 23) then ModelFilePath = "/cru/tyn1/f709762/goglo/deg25.ref"

; if the file stated here does not exist, then to construct it...
;   compare the HadCM2 (3,103) files, and modify the 000 series similarly to get the 100 series

if (ModelChosen EQ 101) then ModelFilePath = "/cru/tyn1/f709762/goglo/obshulme-ext.ref"
if (ModelChosen EQ 102) then ModelFilePath = "/cru/tyn1/f709762/goglo/echam4-opyc3-ext.ref"
if (ModelChosen EQ 103) then ModelFilePath = "/cru/tyn1/f709762/goglo/hadcm2-ext.ref"
if (ModelChosen EQ 104) then ModelFilePath = "/cru/tyn1/f709762/goglo/hadcm3-ext.ref"
if (ModelChosen EQ 105) then ModelFilePath = "/cru/tyn1/f709762/goglo/cgcm1-ext.ref"
if (ModelChosen EQ 106) then ModelFilePath = "/cru/tyn1/f709762/goglo/csiro-ext.ref"
if (ModelChosen EQ 107) then ModelFilePath = "/cru/tyn1/f709762/goglo/ccsr-nies-ext.ref"
if (ModelChosen EQ 108) then ModelFilePath = "/cru/tyn1/f709762/goglo/echam3-lsg-ext.ref"
if (ModelChosen EQ 109) then ModelFilePath = "/cru/tyn1/f709762/goglo/gfdl-ext.ref"
if (ModelChosen EQ 110) then ModelFilePath = "/cru/tyn1/f709762/goglo/ncar-cgcm-ext.ref"
if (ModelChosen EQ 111) then ModelFilePath = "/cru/tyn1/f709762/goglo/ncar-pcm3-ext.ref"
if (ModelChosen EQ 112) then ModelFilePath = "/cru/tyn1/f709762/goglo/half-degree-ext.ref"
if (ModelChosen EQ 113) then ModelFilePath = "/cru/tyn1/f709762/goglo/tenmin-euro.ref"
if (ModelChosen EQ 114) then ModelFilePath = "/cru/tyn1/f709762/goglo/half-degree-euro.ref"
if (ModelChosen EQ 115) then ModelFilePath = "/cru/tyn1/f709762/goglo/tenmin-ateam.ref"
if (ModelChosen EQ 116) then ModelFilePath = "/cru/tyn1/f709762/goglo/regridx2-ext.ref"
if (ModelChosen EQ 117) then ModelFilePath = "/cru/tyn1/f709762/goglo/tenmin-brit.ref"
if (ModelChosen EQ 118) then ModelFilePath = "/cru/tyn1/f709762/goglo/richjones-ext.ref"
if (ModelChosen EQ 119) then ModelFilePath = "/cru/tyn1/f709762/goglo/hadcm2-ext.ref"
if (ModelChosen EQ 120) then ModelFilePath = "/cru/tyn1/f709762/goglo/ng5-ext.ref"
if (ModelChosen EQ 121) then ModelFilePath = "/cru/tyn1/f709762/goglo/ng5cut-ext.ref"
if (ModelChosen EQ 122) then ModelFilePath = "/cru/tyn1/f709762/goglo/five-degree-ext.ref"
if (ModelChosen EQ 123) then ModelFilePath = "/cru/tyn1/f709762/goglo/deg25-ext.ref"

if (ModelFilePath EQ 'missing') then print, "  > ##### SelectModel: model unknown: gonna crash #####"

ModelFilePath = strtrim (ModelFilePath, 2)

openr, lunMod, ModelFilePath, /get_lun
readf, lunMod, ModelTitle, format='(a10)'						; title
readf, lunMod, ModelLongN, ModelLatN, ModelDataN, format='(2(I4),I6)'			; params
free_lun, lunMod

end
