; feed this routine with the filepath
; it will find the variable and unit names, if they are there to be found

pro SearchVari, FilePath, VariName, UnitName

VariName = "missing" & UnitName = "missing"
StringN = 7 & FoundN = 0

SearchStr = strarr (StringN)
SearchStr = ['.cld','.dtr','.pre','.prr','.prc','.tmp','.vap']

VariStr = strarr (StringN)
VariStr = ['cloud cover','DTR','precipitation','precipitation','precipitation','temperature','vapour pressure']

UnitStr = strarr (StringN)
UnitStr = ['percentage','degC','mm','mm/day','percentage','degC','hPa']

if (FilePath NE "") then begin
  for XSearch = 0, (StringN-1) do begin
    if (strpos(FilePath,SearchStr(XSearch)) NE -1) then begin
    	VariName = VariStr(XSearch)
    	UnitName = UnitStr(XSearch)
    	FoundN = FoundN + 1
    endif
  endfor
endif

if (FoundN NE 1) then begin
  VariName = "missing" & UnitName = "missing"
  
  InputInt = -1 
  while (VariName EQ "missing") do begin
   print, "  > Identify the variable (-1=list): "
   read, InputInt
    
   if (InputInt EQ -1) then begin
     for XString = 0, (StringN-1) do begin
       print, "  > ", XString, " : ", VariStr(XString), format='(a4,i2,a3,a)'
     endfor
   endif else begin
     if (InputInt LT 0 OR InputInt GT (StringN-1)) then begin
       print, "  > Try again."
     endif else begin
       VariName = VariStr (InputInt)
       UnitName = UnitStr (InputInt)
     endelse
   endelse
  endwhile
endif

end
