; feed this routine with the filepath and file info line
; it will find the season, if it is there to be found
; seas index returns 1...12 (month), 13...16 (season), 17 (annual)

pro SearchSeas, FilePath, FileInfo, SeasName, SeasIndex=SeasIndex

SeasName = "missing"
StringN = 34 & FoundN = 0

SearchStr = strarr (StringN)
SearchStr = ['jan','feb','mar','apr','may','jun','jul','aug','sep','oct','nov','dec','MAM','JJA','SON','DJF','ANN', $
             'Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec','mam','jja','son','djf','ann']

SeasStr = strarr (StringN)     
SeasStr = ['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec','MAM','JJA','SON','DJF','annual', $
           'Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec','MAM','JJA','SON','DJF','annual'] 

Text = strarr (2)
Text[0] = FilePath & Text[1] = FileInfo

for XText = 0, 1 do begin            
 if (FoundN EQ 0) then begin
  for XSearch = 0, (StringN-1) do begin
    if (strpos(Text[XText],SearchStr(XSearch)) NE -1) then begin
    	SeasName = SeasStr(XSearch)
    	SeasIndex = XSearch + 1
    	if (SeasIndex GT 17) then SeasIndex = SeasIndex - 17
    	FoundN = FoundN + 1
    endif
  endfor
 endif
endfor

if (FoundN NE 1) then begin
  SeasName = "missing"
  
  InputInt = -1 
  while (SeasName EQ "missing") do begin
   print, "  > Identify the season (-1=list): "
   read, InputInt
   SeasIndex = InputInt + 1
   if (SeasIndex GT 17) then SeasIndex = SeasIndex - 17
    
   if (InputInt EQ -1) then begin
     for XString = 0, ((StringN/2)-1) do begin
       print, "  > ", XString, " : ", SeasStr(XString), format='(a4,i2,a3,a)'
     endfor
   endif else begin
     if (InputInt LT 0 OR InputInt GT ((StringN/2)-1)) then begin
       print, "  > Try again."
     endif else begin
       SeasName = SeasStr (InputInt)
     endelse
   endelse
  endwhile
endif

end
