; feed this routine with the filepath and file info line, and a string giving details of the purpose of GCM
; it will find the GCM used, if it is there to be found

pro SearchGcm, FilePath, FileInfo, GcmName, IdentifyText

GcmName = "missing"
StringN = 14 & FoundN = 0

SearchStr = strarr (StringN)
SearchStr = ['HadCM2','HadCM3','ECHam4','GFDL','CSIRO2','CGCM1','Obs',$
	     'had2','had3','ech4','gfdl','csiro2','cgcm1','obs']

GcmStr = strarr (StringN)     
GcmStr = ['HadCM2','HadCM3','ECHam4','GFDL','CSIRO2','CGCM1','observations',$ 
	  'HadCM2','HadCM3','ECHam4','GFDL','CSIRO2','CGCM1','observations']

Text = strarr (2)
Text[0] = FilePath & Text[1] = FileInfo

for XText = 0, 1 do begin            
 if (FoundN EQ 0) then begin
  for XSearch = 0, (StringN-1) do begin
    if (strpos(Text[XText],SearchStr(XSearch)) NE -1) then begin
    	GcmName = GcmStr(XSearch)
    	FoundN = FoundN + 1
    endif
  endfor
 endif
endfor

if (FoundN NE 1) then begin
  GcmName = "missing"
  
  InputInt = -1 
  while (GcmName EQ "missing") do begin
   print, "  > Identify the GCM (-1=list): ", IdentifyText
   read, InputInt
    
   if (InputInt EQ -1) then begin
     for XString = 0, ((StringN/2)-1) do begin
       print, "  > ", XString, " : ", GcmStr(XString), format='(a4,i2,a3,a)'
     endfor
   endif else begin
     if (InputInt LT 0 OR InputInt GT ((StringN/2)-1)) then begin
       print, "  > Try again."
     endif else begin
       GcmName = GcmStr (InputInt)
     endelse
   endelse
  endwhile
endif

end
