; routine to plot poly
; should be used in tandem with SelectPoly
; if anything changes below, change SelectPoly accordingly

pro PlotPoly, CallPoly, _extra=e

Trash = "" & MissVal = -999.0

case 1 of
(CallPoly EQ 1) : begin
	PolyFiles     = strarr (1)
	PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/uk.bnd'
end
(CallPoly EQ 2) : begin
	PolyFiles     = strarr (1)
	PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/eire.bnd'
end
(CallPoly EQ 3) : begin
	PolyFiles     = strarr (5)
	PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/jersey.bnd'
	PolyFiles [1] = '/cru/mikeh1/f709762/borders/bnd/uk.bnd'
	PolyFiles [2] = '/cru/mikeh1/f709762/borders/bnd/eire.bnd'
	PolyFiles [3] = '/cru/mikeh1/f709762/borders/bnd/iom.bnd'
	PolyFiles [4] = '/cru/mikeh1/f709762/borders/bnd/guernsey.bnd'
end
(CallPoly EQ 4) : begin
	PolyFiles     = strarr (3)
	PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/eng.county.1991.bnd'
	PolyFiles [1] = '/cru/mikeh1/f709762/borders/bnd/scot.region.1991.bnd'
	PolyFiles [2] = '/cru/mikeh1/f709762/borders/bnd/wales.region.1991.bnd'
end
(CallPoly EQ 5) : begin
	PolyFiles     = strarr (1)
	PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/eng.region.1991.bnd'
end
(CallPoly EQ 6) : begin
	PolyFiles     = strarr (1)
	PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/scot.region.1991.bnd'
end
(CallPoly EQ 7) : begin
	PolyFiles     = strarr (3)
	PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/wales.region.1991.bnd'
end
(CallPoly EQ 8) : begin
	PolyFiles     = strarr (8)
	PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/eng.county.1991.bnd'
	PolyFiles [1] = '/cru/mikeh1/f709762/borders/bnd/scot.region.1991.bnd'
	PolyFiles [2] = '/cru/mikeh1/f709762/borders/bnd/wales.region.1991.bnd'
	PolyFiles [3] = '/cru/mikeh1/f709762/borders/bnd/uk.bnd'
	PolyFiles [4] = '/cru/mikeh1/f709762/borders/bnd/eire.bnd'
	PolyFiles [5] = '/cru/mikeh1/f709762/borders/bnd/jersey.bnd'
	PolyFiles [6] = '/cru/mikeh1/f709762/borders/bnd/guernsey.bnd'
	PolyFiles [7] = '/cru/mikeh1/f709762/borders/bnd/iom.bnd'
end
(CallPoly GE 100 AND CallPoly LE 199) : begin
	PolyFiles     = strarr (1)
	if (CallPoly EQ 101) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/eng.1991.avon_.bnd'
	if (CallPoly EQ 102) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/eng.1991.beds_.bnd'
	if (CallPoly EQ 103) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/eng.1991.berks.bnd'
	if (CallPoly EQ 104) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/eng.1991.bucks.bnd'
	if (CallPoly EQ 105) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/eng.1991.cambs.bnd'
	if (CallPoly EQ 106) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/eng.1991.chesh.bnd'
	if (CallPoly EQ 107) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/eng.1991.cleve.bnd'
	if (CallPoly EQ 108) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/eng.1991.cornw.bnd'
	if (CallPoly EQ 109) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/eng.1991.cumbr.bnd'
	if (CallPoly EQ 110) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/eng.1991.derbs.bnd'
	if (CallPoly EQ 111) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/eng.1991.devon.bnd'
	if (CallPoly EQ 112) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/eng.1991.dorst.bnd'
	if (CallPoly EQ 113) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/eng.1991.durhm.bnd'
	if (CallPoly EQ 114) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/eng.1991.esuss.bnd'
	if (CallPoly EQ 115) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/eng.1991.essex.bnd'
	if (CallPoly EQ 116) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/eng.1991.glouc.bnd'
	if (CallPoly EQ 117) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/eng.1991.manch.bnd'
	if (CallPoly EQ 118) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/eng.1991.hants.bnd'
	if (CallPoly EQ 119) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/eng.1991.herew.bnd'
	if (CallPoly EQ 120) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/eng.1991.herts.bnd'
	if (CallPoly EQ 121) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/eng.1991.humbr.bnd'
	if (CallPoly EQ 122) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/eng.1991.kent_.bnd'
	if (CallPoly EQ 123) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/eng.1991.lancs.bnd'
	if (CallPoly EQ 124) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/eng.1991.leics.bnd'
	if (CallPoly EQ 125) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/eng.1991.lincs.bnd'
	if (CallPoly EQ 126) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/eng.1991.londi.bnd'
	if (CallPoly EQ 127) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/eng.1991.londo.bnd'
	if (CallPoly EQ 128) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/eng.1991.mersy.bnd'
	if (CallPoly EQ 129) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/eng.1991.norfk.bnd'
	if (CallPoly EQ 130) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/eng.1991.nyork.bnd'
	if (CallPoly EQ 131) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/eng.1991.nhant.bnd'
	if (CallPoly EQ 132) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/eng.1991.nrhum.bnd'
	if (CallPoly EQ 133) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/eng.1991.notts.bnd'
	if (CallPoly EQ 134) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/eng.1991.oxfrd.bnd'
	if (CallPoly EQ 135) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/eng.1991.shrop.bnd'
	if (CallPoly EQ 136) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/eng.1991.somer.bnd'
	if (CallPoly EQ 137) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/eng.1991.syork.bnd'
	if (CallPoly EQ 138) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/eng.1991.staff.bnd'
	if (CallPoly EQ 139) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/eng.1991.suffk.bnd'
	if (CallPoly EQ 140) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/eng.1991.surry.bnd'
	if (CallPoly EQ 141) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/eng.1991.tynew.bnd'
	if (CallPoly EQ 142) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/eng.1991.warwk.bnd'
	if (CallPoly EQ 143) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/eng.1991.wmidl.bnd'
	if (CallPoly EQ 144) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/eng.1991.wsuss.bnd'
	if (CallPoly EQ 145) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/eng.1991.wyork.bnd'
	if (CallPoly EQ 146) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/eng.1991.wight.bnd'
	if (CallPoly EQ 147) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/eng.1991.wilts.bnd'
end
(CallPoly GE 200 AND CallPoly LE 299) : begin
	PolyFiles     = strarr (1)
	if (CallPoly EQ 205) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/wales.1991.clwyd.bnd'
	if (CallPoly EQ 206) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/wales.1991.dyfed.bnd'
	if (CallPoly EQ 204) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/wales.1991.gwent.bnd'
	if (CallPoly EQ 207) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/wales.1991.gwynd.bnd'
	if (CallPoly EQ 202) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/wales.1991.mglam.bnd'
	if (CallPoly EQ 208) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/wales.1991.powys.bnd'
	if (CallPoly EQ 201) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/wales.1991.sglam.bnd'
	if (CallPoly EQ 203) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/wales.1991.wglam.bnd'
end
(CallPoly GE 300 AND CallPoly LE 399) : begin
	PolyFiles     = strarr (1)
	if (CallPoly EQ 301) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/scot.1991.bordr.bnd'
	if (CallPoly EQ 302) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/scot.1991.centr.bnd'
	if (CallPoly EQ 303) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/scot.1991.dugal.bnd'
	if (CallPoly EQ 304) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/scot.1991.fife_.bnd'
	if (CallPoly EQ 305) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/scot.1991.gramp.bnd'
	if (CallPoly EQ 306) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/scot.1991.highl.bnd'
	if (CallPoly EQ 307) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/scot.1991.lothi.bnd'
	if (CallPoly EQ 308) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/scot.1991.orkny.bnd'
	if (CallPoly EQ 309) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/scot.1991.shetl.bnd'
	if (CallPoly EQ 310) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/scot.1991.strat.bnd'
	if (CallPoly EQ 311) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/scot.1991.taysd.bnd'
	if (CallPoly EQ 312) then PolyFiles [0] = '/cru/mikeh1/f709762/borders/bnd/scot.1991.westi.bnd'
end
else: begin
	print, "  > ##### ERROR: PlotPoly: CallPoly not recognised. #####"
end
endcase

FilesDim  = size(PolyFiles)
PolyFileN = FilesDim (1)

for XFile = 0, (PolyFileN-1) do begin
  openr, lunPoly, PolyFiles [XFile], /get_lun, error=OpenStatus
  if (OpenStatus NE 0) then printf, -2, !ERR_STRING

  readf, lunPoly, Trash, PolyN, format='(a40,i6)'
  
  for XPoly = 0, (PolyN-1) do begin
    readf, lunPoly, Trash, ThisPoly, PolyNodeN, format='(a13,2i6)'
    
    NewX=MissVal & NewY=MissVal & XNode=0L & NodeN=long(PolyNodeN)
    for XNode = 0L, (NodeN-1L) do begin
      OldX=NewX & OldY=NewY
      readf, lunPoly, NewX, NewY, format='(2f12.5)'
      if (OldX NE MissVal AND OldY NE MissVal) then plots, [OldX,NewX], [OldY,NewY], _extra=e
    endfor
  endfor
  
  free_lun, lunPoly
endfor 

end
