pro PlotCircle, YearAD, Daily, PSColours, PlotYear0,PlotYear1, MissColour, Screen=Screen,SpecUnitArea=SpecUnitArea

Dims    = size (Daily)
ColN    = Dims (1)
YearN   = Dims (2)
JulianN = Dims (3)

MissVal = -999.0

if (keyword_set(SpecUnitArea)) then begin
  UnitArea = SpecUnitArea
endif else begin
  UnitArea = 1
endelse

if (YearAD(0) GT PlotYear0) then begin
  VecX=[(PlotYear0-0.5),(PlotYear0-0.5),(YearAD(0)-0.5),(YearAD(0)-0.5),(PlotYear0-0.5)]
  VecY=[-0.5,366.5,366.5,-0.5,-0.5]
  polyfill, VecX, VecY, color=MissColour
endif

for XCol = 0, (ColN-1) do begin
 for XYear = 0, (YearN-1) do begin
  for XJulian = 0, (JulianN-1) do begin     
   if (keyword_set(Screen)) then begin
    Colour = MissColour
   endif else begin
    Colour = PSColours (XCol,XYear,XJulian)
   endelse
  
   if (Daily(XCol,XYear,XJulian) NE MissVal) then begin
     if (Daily(XCol,XYear,XJulian) GT 0) then begin
       CentreX = YearAD(XYear)
       CentreY = XJulian
       CircleRefs, CentreX,CentreY, (PlotYear1-PlotYear0),JulianN, Daily(XCol,XYear,XJulian), VecX,VecY, $
       		SpecUnitArea=UnitArea
       polyfill, VecX, VecY, color=Colour
     endif
   endif else begin
     VecX=[(YearAD(XYear)+0.5),(YearAD(XYear)+0.5),(YearAD(XYear)-0.5),(YearAD(XYear)-0.5),(YearAD(XYear)+0.5)]
     VecY=[(XJulian      +0.5),(XJulian      -0.5),(XJulian      -0.5),(XJulian      +0.5),(XJulian      +0.5)]
     polyfill, VecX, VecY, color=MissColour
   endelse
  endfor
 endfor
endfor

if (YearAD(YearN-1) LT PlotYear1) then begin
  VecX=[(PlotYear1+0.5),(PlotYear1+0.5),(YearAD(YearN-1)+0.5),(YearAD(YearN-1)+0.5),(PlotYear1+0.5)]
  VecY=[-0.5,366.5,366.5,-0.5,-0.5]
  polyfill, VecX, VecY, color=MissColour
endif

end
