; input is model chosen and the last plot view boundaries
; interrogates keyboard instead of mouse
; checks that lat and long are within view boundaries (i.e. not on another plot)
; if so, converts into XLong (Exe) and XLat (Wye) and returns also with integer in Button

pro ManualMouse, ViewBounds, ModelChosen, Exe, Wye

MissVal = -999.0
ExeCoord = MissVal &	WyeCoord = MissVal
Exe = -1 & 		Wye = -1 &		Button = -1
CheckReturn = 0 &	ExitYet = 0

while (CheckReturn EQ 0) do begin      
      ExitYet = 0
      print, "  > Enter the lat,long in degrees: "
      while (ExitYet EQ 0) do begin
        read, WyeCoord, ExeCoord 
        if (WyeCoord GE -90 AND WyeCoord LE 90 AND ExeCoord GE -180 AND WyeCoord LE 180) then ExitYet = 1
      endwhile
        							; ViewBounds = lonmin, lonmax, latmin, latmax
      if   (ExeCoord GE ViewBounds[0] AND ExeCoord LE ViewBounds [1]  AND $
              WyeCoord GE ViewBounds[2] AND WyeCoord LE ViewBounds [3]) then begin          
          CoordToBox, ModelChosen, ExeCoord, WyeCoord, Exe, Wye          	  
          CheckReturn = 1
      endif else begin      
          print, "  > Selected point beyond view boundaries. Re-enter."
      endelse
endwhile

end
