; interrogates .glo file and loads it
; called with the ModelFilePath that the .glo ought to conform to
; returns GloSlice

pro LoadGlo, ModelChosen, GloSlice, FilePath, FileInfo, Silent=Silent

ExitStatus = 0
FileInfo = "" & 	GloFormat = "" & 	ModelFilePath = ""
ModelLongN = 0 & 	ModelLatN = 0 & 	Trash=""
MissVal = -999.0

Datum0=0.0 & 	Datum1=0.0 &	Datum2=0.0 &	Datum3=0.0
Datum4=0.0 & 	Datum5=0.0 &	Datum6=0.0 & 	Datum7=0.0 & Datum8=0.0 & Datum9=0.0

while (ExitStatus NE 1) do begin				; initial interrogation
 OpenStatus = -1
 if (FilePath EQ "") then print, "  > Enter the filepath of the .glo file: "
 
 while (OpenStatus NE 0) do begin
    if (FilePath EQ "") then read, FilePath
    FilePath = strtrim(FilePath,2)
    openr, lunGlo, FilePath, /get_lun, error=OpenStatus
    if (OpenStatus NE 0) then begin
    	FilePath = ""
    	print, "  > File cannot be opened. Re-enter filepath."
    endif
 endwhile  

 readf, lunGlo, FileInfo,  format='(a80)'			; title
 readf, lunGlo, GloFormat, format='(a10)'			; format
 FileInfo  = strtrim (FileInfo ,2)
 GloFormat = strtrim (GloFormat,2)
 
 if (strmid (GloFormat,1,2) EQ '10') then begin
   XLetter = 4
 endif else begin
   XLetter = 3
 endelse
 
 FormatType = strmid (GloFormat, (XLetter-1), 1)
 if (FormatType NE 'E' AND FormatType NE 'F') then begin
    free_lun, lunGlo
    openr, lunGlo, FilePath, /get_lun
    readf, lunGlo, FileInfo, format='(a80)'			; title
    GloFormat = '(8F12.4)'					; format
 endif

 readf, lunGlo, ModelLongN, ModelLatN, format='(2i6)'		; dims
 readf, lunGlo, ModelFilePath, format='(a80)'			; model details filepath
 ModelFilePath = strtrim(ModelFilePath,2)
 								; get check details
 CheckModel = ModelChosen
 if (CheckModel GE 100) then CheckModel = CheckModel - 100
 SelectModel, CheckModel, CheckFilePath, CheckLongN, CheckLatN
 
 if (CheckFilePath EQ ModelFilePath) then begin			; perform check
   ExitStatus = 1
 endif else begin
   ExitStatus = 1
   
   openr, lunChk, CheckFilePAth, /get_lun
   readf, lunChk, Trash, format="(a)"
   readf, lunChk, CheckLongN,CheckLatN, format="(2i4)"
   free_lun, lunChk
   
   if (CheckLongN ne ModelLongN or CheckLatN ne ModelLatN) then begin
     print, "  > @@@@@ FATAL: File is on the wrong model grid. @@@@@"
     print, strtrim(CheckFilePath)
     print, strtrim(ModelFilePath)
   endif
 endelse
endwhile

if (NOT keyword_set(Silent)) then print, "  > ", strtrim(FileInfo,2)

GloSlice = dblarr (ModelLongN,ModelLatN)			; output array

if (strmid (GloFormat,1,1) EQ '8') then begin  
 for XLat = 0, (ModelLatN-1) do begin				; load into output array
  for XEight = 0, (floor(ModelLongN/8)-1) do begin
    Long0 = XEight*8
  
    readf, lunGlo, Datum0,Datum1,Datum2,Datum3,Datum4,Datum5,Datum6,Datum7, format=GloFormat
  
    GloSlice ((Long0+0),XLat) = Datum0
    GloSlice ((Long0+1),XLat) = Datum1
    GloSlice ((Long0+2),XLat) = Datum2
    GloSlice ((Long0+3),XLat) = Datum3
    GloSlice ((Long0+4),XLat) = Datum4
    GloSlice ((Long0+5),XLat) = Datum5
    GloSlice ((Long0+6),XLat) = Datum6
    GloSlice ((Long0+7),XLat) = Datum7
  
  endfor
 endfor
endif else if (strmid (GloFormat,1,2) EQ '10') then begin
 for XLat = 0, (ModelLatN-1) do begin				; load into output array
  for XTen = 0, (floor(ModelLongN/10)-1) do begin
    Long0 = XTen*10
  
    readf, lunGlo, Datum0,Datum1,Datum2,Datum3,Datum4,Datum5,Datum6,Datum7,Datum8,Datum9, format=GloFormat
  
    GloSlice ((Long0+0),XLat) = Datum0
    GloSlice ((Long0+1),XLat) = Datum1
    GloSlice ((Long0+2),XLat) = Datum2
    GloSlice ((Long0+3),XLat) = Datum3
    GloSlice ((Long0+4),XLat) = Datum4
    GloSlice ((Long0+5),XLat) = Datum5
    GloSlice ((Long0+6),XLat) = Datum6
    GloSlice ((Long0+7),XLat) = Datum7
    GloSlice ((Long0+8),XLat) = Datum8
    GloSlice ((Long0+9),XLat) = Datum9
  
  endfor
 endfor
endif else if (strmid (GloFormat,1,1) EQ '6') then begin
 for XLat = 0, (ModelLatN-1) do begin				; load into output array
  for XSix = 0, (floor(ModelLongN/6)-1) do begin
    Long0 = XSix*6
  
    readf, lunGlo, Datum0,Datum1,Datum2,Datum3,Datum4,Datum5, format=GloFormat
  
    GloSlice ((Long0+0),XLat) = Datum0
    GloSlice ((Long0+1),XLat) = Datum1
    GloSlice ((Long0+2),XLat) = Datum2
    GloSlice ((Long0+3),XLat) = Datum3
    GloSlice ((Long0+4),XLat) = Datum4
    GloSlice ((Long0+5),XLat) = Datum5
  
  endfor
 endfor
endif

free_lun, lunGlo

DataTot    =      0.0
DataEn     =      0.0
DataMin    =  10000.0
DataMax    = -10000.0

for XLong = 0, (ModelLongN-1) do begin				; check properties of .glo
  for XLat = 0, (ModelLatN-1) do begin
    if (GloSlice(XLong,XLat) NE MissVal) then begin
     
     DataTot = DataTot + GloSlice(XLong,XLat)
     DataEn  = DataEn  + 1
     
     if            (GloSlice(XLong,XLat) LT DataMin) then begin
      DataMin = GloSlice(XLong,XLat)
     endif else if (GloSlice(XLong,XLat) GT DataMax) then begin
      DataMax = GloSlice(XLong,XLat)
     endif
    
    endif
  endfor
endfor

Valid    = round (DataEn)
DataMean = DataTot / DataEn

if (NOT keyword_set(Silent)) then print, "  > Valid, Mean, Min, Max: ", $
	Valid, DataMean, DataMin, DataMax, format='(a26,i6,3f10.4)'

if (ModelChosen GE 100) then begin				; add extra column
  SelectModel, ModelChosen, ExtendFilePath, ExtendLongN, ExtendLatN, /Extend
  
  if (ExtendLongN GT ModelLongN) then begin
   OldSlice = GloSlice
   GloSlice = dblarr (ExtendLongN,ExtendLatN)
   for XLong = 0, (ExtendLongN-2) do begin
    GloSlice [XLong,*] = OldSlice [XLong,*]
   endfor 
   GloSlice [(ExtendLongN-1),*] = OldSlice [0,*]
   ModelLongN = ExtendLongN & ModelLatN = ExtendLatN
  
;   print, "  > Expanded to include an extra column."
  endif
endif

end
