; interrogates .cts or .hdr file and loads the headers
; supply CallFile (optional)
; returns Code,Lat,Long,Elv,YearAD0,YearAD1,NameStn,NameCty

pro LoadCRUtsHeads, Code,Lat,Lon,Elv,YearAD0,YearAD1,NameStn,NameCty, $
	CallFile=CallFile,Data=Data,YearAD=YearAD,TmpPre=TmpPre,Divisor=Divisor

HeaderFormat="(i7,i6,i7,i5,x,a20,x,a13,x,i4,x,i4,i7,a9)"
DataFormat="(i4,12i5)"

ExitStatus = 0 & LineN = 0L & YearMin = 1000000 & YearMax = -10000000
MissVal = -999.0 & HYear=0
LoadFile = "" & Trash = ""
HWmo=0L & HLat=0 & HLong=0 & HElv=0 & HName="" & HCty="" & HYear0=0 & HYear1=0 & HGcm=0 & HLocal=""
Int0=0L & Int1=0L & Int2=0L & Int3=0L & Int4=0L & Int5=0L
Int6=0L & Int7=0L & Int8=0L & Int9=0L & Int10=0L & Int11=0L

OpenStatus = -1
if (keyword_set(CallFile)) then LoadFile = CallFile
 
if (LoadFile EQ "") then print, "  > Enter the filepath of the .cts file: "
 
while (OpenStatus NE 0) do begin
    if (LoadFile EQ "") then read, LoadFile
    LoadFile = strtrim(LoadFile,2)
    openr, lunCTS, LoadFile, /get_lun, error=OpenStatus
    if (OpenStatus NE 0) then begin
    	LoadFile = ""
    	print, "  > File cannot be opened. Re-enter filepath."
    endif else begin
        free_lun, lunCTS
    endelse

    CTSPos = strpos(LoadFile,'.cts')
    if (CTSPos EQ -1) then CTSPos = strpos(LoadFile,'.src')
    DtbPos = strpos(LoadFile,'.dtb')
    HdrPos = strpos(LoadFile,'.hdr')
    
    if (CTSPos EQ -1 AND HdrPos EQ -1 AND DtbPos EQ -1) then begin
    	OpenStatus = -1 & LoadFile = ""
    	print, "  > File does not have .cts, .src, .hdr, .dtb suffix. Try again."
    endif
endwhile  
 
TmpPre=0 & Divisor=10.0

QTmpPre = strpos(LoadFile,'pre') 
if (QTmpPre GE 0) then begin
	TmpPre=1 & Divisor=10.0 & print,"  > Detected .pre"
endif
QTmpPre = strpos(LoadFile,'vap') 
if (QTmpPre GE 0) then begin
	TmpPre=1 & Divisor=10.0 & print,"  > Detected .vap"
endif
QTmpPre = strpos(LoadFile,'cld') 
if (QTmpPre GE 0) then begin
	TmpPre=1 & Divisor=100.0 & print,"  > Detected .cld"
endif
QTmpPre = strpos(LoadFile,'wet') 
if (QTmpPre GE 0) then begin
	TmpPre=1 & Divisor=100.0 & print,"  > Detected .wet"
endif
 
ShellCommand = 'wc -l ' + strtrim(LoadFile,2) + ' > trashmequick'
spawn, ShellCommand
openr, lunWCL, 'trashmequick', /get_lun, error=OpenStatus
readf, lunWCL, LineN
free_lun, lunWCL
spawn, 'rm trashmequick'
print, "  > Number of lines in file: ", LineN

openr, lunCTS, LoadFile, /get_lun, error=OpenStatus 
XLine = -1L & StationN = 0
while (XLine LT (LineN-1)) do begin
   XLine = XLine + 1 & StationN = StationN + 1
   readf, lunCTS, HWmo,HLat,HLong,HElv,HName,HCty,HYear0,HYear1,HGcm,HLocal, $
     		format=strtrim(HeaderFormat,2)
   if (HYear0 LT YearMin) then YearMin = HYear0
   if (HYear1 GT YearMax) then YearMax = HYear1
   
   if (CtsPos NE -1 OR DtbPos NE -1) then begin    
     if (DtbPos NE -1) then begin
     	readf, lunCTS, Trash, format="(a1)"
     	XLine = XLine + 1
     endif
     for XYear = HYear0,HYear1 do begin
      readf, lunCTS, Trash, format="(a1)"
     endfor
     XLine = XLine + HYear1 - HYear0 + 1
   endif
endwhile 
free_lun, lunCTS
YearN = YearMax - YearMin + 1 & MonthN = 12

Code=lonarr(StationN) & Lat=fltarr(StationN) & Lon=fltarr(StationN) & Elv=fltarr(StationN) 
YearAD0=intarr(StationN) & YearAD1=intarr(StationN) & NameStn=strarr(StationN) & NameCty=strarr(StationN)
if (arg_present(Data)) then begin
  Data=fltarr(StationN,MonthN,YearN) & Data(*,*,*)=-999.9
endif
if (arg_present(YearAD)) then begin
  YearAD=intarr(YearN)
  for XYear = 0, (YearN - 1) do begin
    YearAD(XYear) = YearMin + XYear
  endfor
endif

openr, lunCTS, LoadFile, /get_lun, error=OpenStatus 
XLine = -1L & XStation = -1
while (XLine LT (LineN-1)) do begin
   XLine = XLine + 1 & XStation = XStation + 1
   readf, lunCTS, HWmo,HLat,HLong,HElv,HName,HCty,HYear0,HYear1,HGcm,HLocal, format=strtrim(HeaderFormat,2)
   
   Code(XStation)=HWmo 
   Lat(XStation)=float(HLat) & Lon(XStation)=float(HLong) & Elv(XStation)=float(HElv)   
   YearAD0(XStation)=HYear0 & YearAD1(XStation)=HYear1 & NameStn(XStation)=HName & NameCty(XStation)=HCty
   
   if (Lat(XStation) NE  -9999) then Lat(XStation)=Lat(XStation)/100.0 else Lat(XStation)=-999.0
   if (Lon(XStation) NE -99999) then Lon(XStation)=Lon(XStation)/100.0 else Lon(XStation)=-999.0
   if (Elv(XStation) NE   -999) then Elv(XStation)=Elv(XStation)/1.0   else Elv(XStation)=-999.0
   
   if (CtsPos GE 0 OR DtbPos GE 0) then begin    
    if (keyword_set(Data)) then begin
     if (DtbPos GE 0) then readf, lunCTS, Trash, format="(a1)"
     
     for XHYear = HYear0,HYear1 do begin
      XYear = XHYear - YearMin
      readf, lunCTS, HYear,Int0,Int1,Int2,Int3,Int4,Int5,Int6,Int7,Int8,Int9,Int10,Int11, format="(i4,12i5)"
      Data(XStation,0,XYear)=float(Int0)/Divisor & Data(XStation,1,XYear)=float(Int1)/Divisor & Data(XStation,2,XYear)=float(Int2)/Divisor 
      Data(XStation,3,XYear)=float(Int3)/Divisor & Data(XStation,4,XYear)=float(Int4)/Divisor & Data(XStation,5,XYear)=float(Int5)/Divisor 
      Data(XStation,6,XYear)=float(Int6)/Divisor & Data(XStation,7,XYear)=float(Int7)/Divisor & Data(XStation,8,XYear)=float(Int8)/Divisor 
      Data(XStation,9,XYear)=float(Int9)/Divisor & Data(XStation,10,XYear)=float(Int10)/Divisor & Data(XStation,11,XYear)=float(Int11)/Divisor 
     endfor
    endif else begin
     if (DtbPos GE 0) then readf, lunCTS, Trash, format="(a1)"
     
     for XHYear = HYear0,HYear1 do begin
      readf, lunCTS, Trash, format="(a1)"
     endfor
    endelse
    
    XLine = XLine + HYear1 - HYear0 + 1
    if (DtbPos GE 0) then XLine = XLine + 1
   endif
endwhile 
free_lun, lunCTS

if (keyword_set(Data)) then begin
  Missings = where (Data EQ (-9999.0/Divisor), Count)
  if (Count GT 0) then Data [Missings] = !Values.F_NaN
endif

end
