; enables any colour table to be loaded
; input: the colour table index number: 0<no<40=idltable, no>40=userdefined

pro LoadAnyCT, ColTab

ColFile = ""

Red   = intarr (255)
Green = intarr (255)
Blue  = intarr (255)

if (ColTab LE 40 AND ColTab GE 0) then begin
  loadct, ColTab, /silent
endif else begin
  if (ColTab  EQ 50) then ColFile = '/cru/tyn1/f709762/idlcolours/tricolour.dat'
  if (ColTab  EQ 51) then ColFile = '/cru/tyn1/f709762/idlcolours/darkroyal.dat'
  if (ColTab  EQ 52) then ColFile = '/cru/tyn1/f709762/idlcolours/tricolour-block.dat'
  if (ColTab  EQ 53) then ColFile = '/cru/tyn1/f709762/idlcolours/accuracy-block.dat'
  if (ColTab  EQ 54) then ColFile = '/cru/tyn1/f709762/idlcolours/reverse-b+w.dat'
  if (ColTab  EQ 55) then ColFile = '/cru/tyn1/f709762/idlcolours/black-white-black.dat'
  if (ColTab  EQ 56) then ColFile = '/cru/tyn1/f709762/idlcolours/step-b+w.dat'
  if (ColTab  EQ 57) then ColFile = '/cru/tyn1/f709762/idlcolours/sig-b+w.dat'
  if (ColTab  EQ 58) then ColFile = '/cru/tyn1/f709762/idlcolours/step7-b+w.dat'
  if (ColTab  EQ 59) then ColFile = '/cru/tyn1/f709762/idlcolours/step8-b+w.dat'
  if (ColTab  EQ 60) then ColFile = '/cru/tyn1/f709762/idlcolours/pre.abs3.dat'
  if (ColTab  EQ 61) then ColFile = '/cru/tyn1/f709762/idlcolours/tmp.abs3.dat'
  if (ColTab  EQ 62) then ColFile = '/cru/tyn1/f709762/idlcolours/tmp.ano3.dat'
  if (ColTab  EQ 63) then ColFile = '/cru/tyn1/f709762/idlcolours/pre.abs3.dat'
  if (ColTab  EQ 64) then ColFile = '/cru/tyn1/f709762/idlcolours/pre.ano2.dat'
  
  if (ColFile EQ "") then begin
    print, "  > Enter the colour table file (/cru/tyn1/f709762/idlcolours/): "
    read, ColFile
  endif
  
  openr, lunCol, ColFile, /get_lun
  for XCol = 0, 254 do begin
      readf, lunCol, DatumInt1, DatumInt2, DatumInt3
      Red  [XCol] = DatumInt1
      Green[XCol] = DatumInt2
      Blue [XCol] = DatumInt3
  endfor
  free_lun, lunCol
    
  tvlct, Red, Green, Blue
endelse

tvlct,   0,   0,   0,   0		; black
tvlct, 200, 200, 200, 254		;  grey
tvlct, 255, 255, 255, 255		; white

end
