; provides vectors for drawing scales on plots: ScaleLevels, ScaleColors
; input = vector of scale and colour limits: ScaleLimits
; input = number of segments in scale

pro GetScaleVectors, Limits, Levels, Colors, SegmentN

ColorIncrement = 0.0D 
LevelIncrement = 0.0D

ColorIncrement = (Limits[3] - Limits[2]) / SegmentN 
LevelIncrement = (Limits[1] - Limits[0]) / SegmentN

Levels = fltarr (SegmentN+1)
Colors = fltarr (SegmentN+1)

for XUnit = 0, SegmentN do begin
       Levels [XUnit] = Limits [0] + (XUnit * LevelIncrement)
       Levels [XUnit] = Levels [XUnit] * 1000.0
       Levels [XUnit] = round (Levels [XUnit])
       Levels [XUnit] = Levels [XUnit] / 1000.0
       
       Colors [XUnit] = Limits [2] + ((XUnit+0.5) * ColorIncrement)
endfor
      
end
