; takes SelArray, CurrentReg, ModelLongN, ModelLatN, ModelChosen, Spread
; returns CurrentRegBounds: lonmin, lonmax, latmin, latmax

pro GetRegBounds, SelArray, CurrentReg, ModelLongN, ModelLatN, ModelChosen, Spread, CurrentRegBounds

MissVal = -999.0

CurrentRegBounds     = dblarr (4)
CurrentRegBounds (*) = MissVal
    
for XLong = 0, (ModelLongN-1) do begin					; refresh RegBounds for this Reg
  for XLat = 0, (ModelLatN-1) do begin
    if (SelArray(XLong,XLat) EQ CurrentReg) then begin
      BoxToCoord, ModelChosen, ExeCoord, WyeCoord, XLong, XLat
      
      if (CurrentRegBounds(0) EQ MissVal) then begin
        CurrentRegBounds(0) = ExeCoord
        CurrentRegBounds(1) = ExeCoord
        CurrentRegBounds(2) = WyeCoord
        CurrentRegBounds(3) = WyeCoord
      endif else begin
        if (ExeCoord LT CurrentRegBounds(0)) then CurrentRegBounds(0) = ExeCoord
        if (ExeCoord GT CurrentRegBounds(1)) then CurrentRegBounds(1) = ExeCoord
        if (WyeCoord LT CurrentRegBounds(2)) then CurrentRegBounds(2) = WyeCoord
        if (WyeCoord GT CurrentRegBounds(3)) then CurrentRegBounds(3) = WyeCoord
      endelse
      
    endif
  endfor
endfor

if (CurrentRegBounds(0) NE MissVal) then begin
  CurrentRegBounds(0) = CurrentRegBounds(0) - Spread			; spread the limits
  CurrentRegBounds(1) = CurrentRegBounds(1) + Spread
  CurrentRegBounds(2) = CurrentRegBounds(2) - Spread
  CurrentRegBounds(3) = CurrentRegBounds(3) + Spread

  if (CurrentRegBounds(0) LT -179.5) then CurrentRegBounds(0) = -179.5	; but not too far
  if (CurrentRegBounds(1) GT  179.5) then CurrentRegBounds(1) =  179.5
  if (CurrentRegBounds(2) LT  -90)   then CurrentRegBounds(2) =  -90
  if (CurrentRegBounds(3) GT   90)   then CurrentRegBounds(3) =   90
endif

end
