pro GetMonthLengths, YearAD, MonthLengths

Rem004=0 & Rem100=0 & Rem400=0

Dims     = size (YearAD)
SubYearN = Dims (1)

MonthLengths       = intarr (SubYearN,12)
MonthLengths [*,*] = 31

for XYear = 0, (SubYearN-1) do begin
  MonthLengths(XYear,3 ) = 30
  MonthLengths(XYear,5 ) = 30
  MonthLengths(XYear,8 ) = 30
  MonthLengths(XYear,10) = 30
  
  Rem004 = YearAD(XYear) - (floor(float(YearAD(XYear)) /   4.0) *   4)
  Rem100 = YearAD(XYear) - (floor(float(YearAD(XYear)) / 100.0) * 100)
  Rem400 = YearAD(XYear) - (floor(float(YearAD(XYear)) / 400.0) * 400)
  
  if (Rem004 EQ 0) then begin
    if (Rem100 EQ 0) then begin
      if (Rem400 EQ 0) then begin
        MonthLengths(XYear,1) = 29
      endif else begin
        MonthLengths(XYear,1) = 28
      endelse
    endif else begin
        MonthLengths(XYear,1) = 29
    endelse
  endif else begin
        MonthLengths(XYear,1) = 28
  endelse
endfor

end
