; provide this routine with the area for the main plot and the no. of cols, rows
;   it will supply the corners of each individual plot
;   a rectangle is calc for each plot, and PlotCorners is this rectangle with 0.02 chopped off
;   some programs may require further indents, e.g. for axis labels, to be added in main program
;   all co-ord have normal references 
; may set either Indent or IndentX,IndentY
; NOTE: 26.04.01: IndentX,IndentY --> XIndent,YIndent

pro GetCorners,MainCorners,PlotCorners,ColN,RowN,Order,Indent=Indent,XIndent=XIndent,YIndent=YIndent

PlotN = ColN * RowN

PlotCorners = fltarr (PlotN,4)
PlotArrange = fltarr (ColN,RowN,4)

Width  = MainCorners [2] - MainCorners [0]
Height = MainCorners [3] - MainCorners [1]

if (PlotN EQ 1) then begin
  PlotCorners [0,*] = MainCorners [*]
endif else begin
  ColProp = 1.0 / float(ColN)
  RowProp = 1.0 / float(RowN)

  for XCol = 0, (ColN-1) do begin
    ColBeg = (float(XCol+0) * (ColProp * Width)) + MainCorners [0]
    ColEnd = (float(XCol+1) * (ColProp * Width)) + MainCorners [0]
    
    for XRow = 0, (RowN-1) do begin
      PlotArrange [XCol,XRow,0] = ColBeg
      PlotArrange [XCol,XRow,2] = ColEnd
    endfor
  endfor
  
  for XCol = 0, (ColN-1) do begin
    for XRow = 0, (RowN-1) do begin    
      RowBeg = (float(XRow+0) * (RowProp * Height)) + MainCorners [1]
      RowEnd = (float(XRow+1) * (RowProp * Height)) + MainCorners [1]
      PlotArrange [XCol,XRow,1] = RowBeg
      PlotArrange [XCol,XRow,3] = RowEnd      
    endfor
  endfor

  if (Order EQ 0) then begin
   XPlot = 0
   for XRow = (RowN-1),0, -1 do begin    
    for XCol = 0, (ColN-1) do begin
      PlotCorners [XPlot,*] = PlotArrange [XCol,XRow,*]
      XPlot = XPlot + 1
    endfor
   endfor
  endif else begin
   XPlot = 0
   for XCol = 0, (ColN-1) do begin
    for XRow = (RowN-1), 0, -1 do begin    
      PlotCorners [XPlot,*] = PlotArrange [XCol,XRow,*]
      XPlot = XPlot + 1
    endfor
   endfor
  endelse
endelse

if (keyword_set(Indent)) then begin
  ChopOffX = Indent & ChopOffY = Indent
endif else if (keyword_set(XIndent) AND keyword_set(YIndent)) then begin
  ChopOffX = XIndent & ChopOffY = YIndent
endif else begin
  ChopOffX = 0.02 & ChopOffY = 0.02
endelse

PlotCorners [*,0] = PlotCorners [*,0] + ChopOffX
PlotCorners [*,1] = PlotCorners [*,1] + ChopOffY
PlotCorners [*,2] = PlotCorners [*,2] - ChopOffX
PlotCorners [*,3] = PlotCorners [*,3] - ChopOffY

end
