; written by Tim Mitchell on 30.05.01
; takes:
;   the dimensions of a box plot to be plotted soon
;   the corners (Xmin,Ymin,Xmax,Ymax) of the space free for the plot (in normalised co-ords)
; returns:
;   the corners to make available to the plot to ensure proportionality between the scales

pro FitPosArray, ExeN=ExeN, WyeN=WyeN, PosFree=PosFree, PosFit=PosFit

ExeFree = PosFree[2]-PosFree[0]
WyeFree = PosFree[3]-PosFree[1]

ExePerUnit = float(ExeN) / ExeFree
WyePerUnit = float(WyeN) / WyeFree

if (ExePerUnit EQ WyePerUnit) then begin
    ExeRatio = 0.0
    WyeRatio = 0.0
endif else begin
  if (ExePerUnit GT WyePerUnit) then begin
    ExeRatio = 0.0
    WyeRatio = 1.0 - (WyePerUnit / ExePerUnit)
  endif else begin
    ExeRatio = 1.0 - (ExePerUnit / WyePerUnit)
    WyeRatio = 0.0
  endelse
endelse

PosFit = fltarr (4)

PosFit [0] = PosFree [0] + (ExeFree * ExeRatio)
PosFit [1] = PosFree [1] + (WyeFree * (WyeRatio/2))
PosFit [2] = PosFree [2]
PosFit [3] = PosFree [3] - (WyeFree * (WyeRatio/2))
		
end
