pro DrawScale, PlotN=PlotN, ThisPlot=ThisPlot, DataEnds=DataEnds, ColEnds=ColEnds, BandN=BandN

PlotCorners = fltarr (4)				; decide where to plot the scale

if (PlotN EQ 1) then begin
  PlotCorners = [0.90,0.02,0.92,0.98]
endif else begin
  if (PlotN EQ 4) then begin
    if (ThisPlot EQ 0) then PlotCorners = [0.40,0.52,0.42,0.98]
    if (ThisPlot EQ 1) then PlotCorners = [0.90,0.52,0.92,0.98]
    if (ThisPlot EQ 2) then PlotCorners = [0.40,0.02,0.42,0.48]
    if (ThisPlot EQ 3) then PlotCorners = [0.90,0.02,0.92,0.48]
  endif else begin
    print, "  > ##### ERROR: DrawScale: this PlotN is not supported #####"
  endelse
endelse

LabelN    = BandN + 1					; get label text
LabelGap  = (DataEnds(1) - DataEnds(0)) / BandN
LabelData = fltarr (LabelN)

for XLabel = 0, (LabelN-1) do begin
  LabelData(XLabel) = (LabelGap * XLabel) + DataEnds(0)
endfor

LabelText = strcompress(string(LabelData,format='(f7.2)'))
LabelText (0)        = ' ' 
LabelText (LabelN-1) = ' '

ColourN   = max(ColEnds) - min(ColEnds) + 3		; get points to plot
ColourGap = (ColEnds (1) - ColEnds (0)) / (ColourN-2)
WyeGap    = (DataEnds(1) - DataEnds(0)) / (ColourN-2)
Points    = fltarr (2,ColourN)
PointsExe = [0.0,1.0]
PointsWye = fltarr (ColourN)

for XColour = 0, (ColourN-1) do begin
  Points    (*,XColour) = ColEnds(0)  + ((XColour-1)*ColourGap)
  PointsWye (XColour)   = DataEnds(0) + ((XColour-1)*WyeGap)    
endfor

ContourN   = 50						; get contours to plot
ContourGap = (max(ColEnds) - min(ColEnds) + 1.0) / ContourN
LevelFloat = fltarr (ContourN)
Levels     = fix (LevelFloat)

for XContour = 0, (ContourN-1) do begin
  Levels (XContour) = min(ColEnds) + (XContour*ContourGap) 
endfor

plot, [1,DataEnds(1)],/nodata, xrange=[0,1],yrange=DataEnds, ystyle=5, xstyle=5, $
		position=PlotCorners, /noerase

contour, Points,PointsExe,PointsWye, levels=Levels,c_colors=Levels, /cell_fill,/overplot, $
		xrange=[0,1], yrange=DataEnds, ystyle=5, xstyle=5, position=PlotCorners
		
axis, yaxis=5, yticks=(LabelN-1), ytickname=LabelText, yminor=1, yticklen=-0.2, $
		font=5, charsize=0.8, charthick=2
		
end
