; draws key for plotlins.pro

pro DrawKey,KeyCorners,GraphLines,GraphLinesText,GraphEq,GraphEqText,ScatterPlot,ScatterText,$
	TextSize,TextThick,DrawLogo=DrawLogo,DrawDate=DrawDate,DrawAuth=DrawAuth,DrawKey=DrawKey

GraphLinesDims = size (GraphLines)
GraphN = GraphLinesDims [1]
LineN  = GraphLinesDims [2]

LineBeg = KeyCorners [0] + 0.02						; x-axis key locations
LineEnd = KeyCorners [0] + 0.06
TextExe = KeyCorners [0] + 0.07

ExeLogoSize = KeyCorners [2] - KeyCorners [0] - 0.04			; Tyndall logo dimensions
WyeLogoSize = ExeLogoSize / 3.2375776

RowHeight  = 0.0375 * float (TextSize)					; text row height

if (keyword_set(DrawLogo)) then begin					; initial text height + logo placement
	WyeLogo    = KeyCorners [3] - 0.01 - WyeLogoSize
	CurrentWye = WyeLogo - RowHeight
endif else begin
	CurrentWye = KeyCorners [3] - 0.01 - RowHeight
endelse

Author = "Tim Mitchell"							; auto information
DateTime  = systime ()
DateStamp = strmid(DateTime,4,7) + strmid(DateTime,20,4)

if (keyword_set(DrawAuth)) then begin					; author stamp
	xyouts, LineBeg, CurrentWye, Author, font=FontSize, charsize=TextSize, charthick=TextThick, /normal
	CurrentWye = CurrentWye - RowHeight
endif

if (keyword_set(DrawDate)) then begin					; date stamp
  	xyouts, LineBeg, CurrentWye, DateStamp, font=FontSize, charsize=TextSize, charthick=TextThick, /normal
	CurrentWye = CurrentWye - RowHeight
endif
									; separate logo etc from key
if (keyword_set(DrawAuth) OR keyword_set(DrawDate) OR keyword_set(DrawLogo)) then $
	CurrentWye = CurrentWye - RowHeight

if (keyword_set(DrawKey)) then begin
  for XGraph = 0, (GraphN-1) do begin
    for XLine = 0, (LineN-1) do begin
      Text = strtrim(GraphLinesText[XGraph,XLine])
      
      if (strlen(Text) GT 0) then begin
        plots,  [LineBeg,LineEnd], [(CurrentWye+0.01),(CurrentWye+0.01)], /normal,  $
        	Color=GraphLines[XGraph,XLine,1], $			; colour
        	LineStyle=GraphLines[XGraph,XLine,2], $			; line style
        	Thick=GraphLines[XGraph,XLine,3], $			; line thickness
        	PSym=GraphLines[XGraph,XLine,4]				; symbol
        
        GiveSymbol, Text
	xyouts, TextExe, CurrentWye, Text, font=5, charsize=TextSize, charthick=TextThick, /normal
        
        CurrentWye = CurrentWye - RowHeight
      endif
      
      Text = strtrim(GraphEqText[XGraph,XLine])
      
      if (strlen(Text) GT 0) then begin
        plots,  [LineBeg,LineEnd], [(CurrentWye+0.01),(CurrentWye+0.01)], /normal,  $
        	Color=GraphEq[XGraph,XLine,1], $			; colour
        	LineStyle=GraphEq[XGraph,XLine,2], $			; line style
        	Thick=GraphEq[XGraph,XLine,3], $			; line thickness
        	PSym=GraphEq[XGraph,XLine,4]				; symbol
        
        GiveSymbol, Text
	xyouts, TextExe, CurrentWye, Text, font=5, charsize=TextSize, charthick=TextThick, /normal
        
        CurrentWye = CurrentWye - RowHeight
      endif
      
      for XLine2 = 0, (LineN-1) do begin
       Text = strtrim(ScatterText[XGraph,XLine,XLine2])
      
       if (strlen(Text) GT 0) then begin
        plots,  [LineBeg,LineEnd], [(CurrentWye+0.01),(CurrentWye+0.01)], /normal,  $
        	Color=ScatterPlot[XGraph,XLine,XLine2,1], $			; colour
        	LineStyle=ScatterPlot[XGraph,XLine,XLine2,2], $			; line style
        	Thick=ScatterPlot[XGraph,XLine,XLine2,3], $			; line thickness
        	PSym=ScatterPlot[XGraph,XLine,XLine2,4]				; symbol
        
        GiveSymbol, Text
	xyouts, TextExe, CurrentWye, Text, font=5, charsize=TextSize, charthick=TextThick, /normal
        
        CurrentWye = CurrentWye - RowHeight
       endif
      endfor
    endfor
  endfor
endif

if (keyword_set(DrawLogo)) then begin
  read_jpeg, '/cru/u2/f709762/goglo/ref/tyn-logo-torok.jpg', Logo, LogoCT, colors=256, dither=1, /two_pass_quantize
  tvlct, LogoCT(*,0), LogoCT(*,1), LogoCT(*,2)
  tv, Logo, LineBeg, WyeLogo, xsize=ExeLogoSize, ysize=WyeLogoSize, /normal
endif

end
