; fed with data in DataSlice     (real array)
; returns colours in ColourSlice (integer array)
; ModelLongN, ModelLatN, MissingColour (index 0...255) are integers
; ImageScaleLimits = real array size 4

function DataToColours, DataSlice, ImageScaleLimits, ModelLongN, ModelLatN, MissingColour

MissVal = -999.0

RangeFract = 0.0D
ColSelect  = 0.0D

Squashed       = dblarr (ModelLongN,ModelLatN)
Squashed [*,*] = MissVal

ColourSlice       = intarr (ModelLongN,ModelLatN)
ColourSlice (*,*) = MissingColour

for XLong = 0, (ModelLongN-1) do begin
  for XLat = 0, (ModelLatN-1) do begin
    if (DataSlice[XLong,XLat] NE MissVal) then begin

      if            (DataSlice[XLong,XLat] GT ImageScaleLimits[1]) then begin
      	Squashed[XLong,XLat] = ImageScaleLimits[1]
      endif else if (DataSlice[XLong,XLat] LT ImageScaleLimits[0]) then begin
      	Squashed[XLong,XLat] = ImageScaleLimits[0]
      endif else begin
        Squashed[XLong,XLat] = DataSlice[XLong,XLat]
      endelse
      
      RangeFract = (Squashed[XLong,XLat] - ImageScaleLimits[0]) / $
      			(ImageScaleLimits[1] - ImageScaleLimits[0])
      
      ColSelect = (RangeFract * float(ImageScaleLimits[3]-ImageScaleLimits[2])) + float(ImageScaleLimits[2])
      
      ColourSlice[XLong,XLat] = round (ColSelect)	    
    endif
  endfor
endfor

return, ColourSlice

end
