pro CoordToBox, ModelChosen, ExeCoord, WyeCoord, ExeBox, WyeBox

MissVal = -999.0
LongDenom = MissVal & 	LatDenom = MissVal
LongLimit = 0.0 &	LatLimit = 0.0
LongCept = 0.0 &	LatCept  = 0.0
ExeBox = -1 & 		WyeBox = -1

if            (ModelChosen EQ 3) then begin	; HadCM2
    LongDenom = 96.0 & LatDenom  = 72.0
    LongLimit = 95.0 & LatLimit  = 72.0
    LongCept  =180.0 & LatCept   = 90.0
endif else if (ModelChosen EQ 4) then begin	; HadCM3
    LongDenom = 96.0 & LatDenom  = 72.0
    LongLimit = 95.0 & LatLimit  = 72.0
    LongCept  =180.0 & LatCept   = 90.0
endif else if (ModelChosen EQ 12) then begin	; HalfDegree
    LongDenom = 720.0 & LatDenom  = 360.0
    LongLimit = 719.0 & LatLimit  = 359.0
    LongCept  = 180.0 & LatCept   =  90.0
endif else if (ModelChosen EQ 13) then begin	; 10'Europe
    LongDenom =2160.0 & LatDenom  =1080.0
    LongLimit = 479.0 & LatLimit  = 312.0
    LongCept  =  20.0 & LatCept   = -30.0
endif else if (ModelChosen EQ 14) then begin	; HalfDegree Europe
    LongDenom = 720.0 & LatDenom  = 360.0
    LongLimit = 159.0 & LatLimit  = 105.0
    LongCept  =  20.0 & LatCept   = -30.0
endif else if (ModelChosen EQ 15) then begin	; 10'ATEAM
    LongDenom =2160.0 & LatDenom  =1080.0
    LongLimit = 257.0 & LatLimit  = 227.0
    LongCept  =  11.0 & LatCept   = -34.0
endif else if (ModelChosen EQ 17) then begin	; 10'Britain
    LongDenom =2160.0 & LatDenom  =1080.0
    LongLimit =  79.0 & LatLimit  =  71.0
    LongCept  =  11.0 & LatCept   = -49.0
endif else if (ModelChosen EQ 18) then begin	; Richard Jones
    LongDenom = 144.0 & LatDenom  =  72.0
    LongLimit = 143.0 & LatLimit  =  72.0
    LongCept  = 180.0 & LatCept   =  90.0
endif

if (LongLimit NE 0) then begin

  ExeBox = round (float(LongCept+ExeCoord)/float(360.0/LongDenom))	; converts to XLong, XLat
  WyeBox = round (float(LatCept +WyeCoord)/float(180.0/ LatDenom))
          
  if (ExeBox GT LongLimit) then ExeBox = 0				; if XLong or XLat > LongN or LatN
  if (WyeBox GT LatLimit ) then WyeBox = 0				;   returns to other end of range

  if (ExeBox LT 0) then ExeBox = LongLimit				; if XLong or XLat < 0
  if (WyeBox LT 0) then WyeBox = LatLimit				;   returns to other end of range

endif else begin

  print, "  > ##### Error: CoordToBox: Grid unrecognised #####"

endelse

end
