; loads .tim file and smooths it and produces glo from smoothing

MissVal = -999.0

print, ""

SelectModel, ModelChosen, ModelFilePath, ModelLongN, ModelLatN

LoadRef, ModelChosen, ModelLongN, ModelLatN, MapIDLReg, RegSize, RegName, RegColour, RegN

ExitStatus = 0
while (ExitStatus NE 1) do begin  
  LoadTim, TimRegN, YearN, TimRegName, YearAD, TimLoaded
  
  if (TimRegN NE RegN) then print, "  > The .tim file is incompatiable with region set. Retry."
  if (TimRegN EQ RegN) then ExitStatus = 1
endwhile

RegSeries = dblarr (YearN)
RegAye    = dblarr (RegN)
RegBee    = dblarr (RegN)
GloAye    = dblarr (ModelLongN,ModelLatN)
GloBee    = dblarr (ModelLongN,ModelLatN)

lunLog = -1
for XReg = 0, (RegN-1) do begin
  for XYear = 0, (YearN-1) do begin
    RegSeries (XYear) = TimLoaded (XReg,XYear)
  endfor
  
  if (XReg EQ 20) then begin
  	LogFilePath = '/cru/u2/f709762/data/scratch/log-robust.dat'
  	openw, lunLog, LogFilePath, /get_lun
  endif
  
  robust_reg, YearAD, RegSeries, Aye, Bee, WyeFit, lunLog, miss=MissVal
  
  if (XReg EQ 20) then begin
	free_lun, lunLog
  	lunLog = -1
  endif
  
  RegAye (XReg) = Aye
  RegBee (XReg) = Bee
endfor

for XLong = 0, (ModelLongN-1) do begin
  for XLat = 0, (ModelLatN-1) do begin
    if (MapIDLReg(XLong,XLat) NE MissVal) then begin
      GloAye(XLong,XLat) = RegAye(MapIDLReg(XLong,XLat))
      GloBee(XLong,XLat) = RegBee(MapIDLReg(XLong,XLat))
    endif else begin
      GloAye(XLong,XLat) = MissVal
      GloBee(XLong,XLat) = MissVal
    endelse
  endfor
endfor

print, "  > Save 'a' from y=ax+b."
SaveGlo, ModelFilePath, ModelLongN, ModelLatN, GloAye

print, "  > Save 'b' from y=ax+b."
SaveGlo, ModelFilePath, ModelLongN, ModelLatN, GloBee

print, ""

end
