MissVal = -999.0

OneLat = 0.0D
OneLon = 0.0D
OneEle = 0.0D 

Lat = dblarr (75162L)
Lon = dblarr (75162L)
Ele = dblarr (75162L)

Lat [*] =    0.0
Lon [*] =    0.0
Ele [*] = MissVal

Lati = dblarr (313)
Long = dblarr (480)
Elev = dblarr (480,313)

Lati [*]   = 0.0
Long [*]   = 0.0
Elev [*,*] = MissVal

FilePath = '/cru/u4/f080/europe/elv/europe_010.elv'
openr, lunElev, FilePath, /get_lun
for XPoint = 0L, 75161L do begin
  readf, lunElev, OneLat, OneLon, OneEle
  Lat[XPoint] = OneLat
  Lon[XPoint] = OneLon
  Ele[XPoint] = OneEle
endfor
free_lun, lunElev

print, "loaded data..."

for XLati = 0, 312 do begin
  Lati [XLati] = 30.083D  + (double(XLati)*0.16666666D)
endfor

for XLong = 0, 479 do begin
  Long [XLong] = -19.917D + (double(XLong)*0.16666666D)
endfor

for XPoint = 0L, 75161L do begin
  XLati = (Lat(XPoint) - 30.083D) / 0.16666666D
  XLati = fix (XLati)

  XLong = (Lon(XPoint) + 19.917D) / 0.16666666D
  XLong = fix (XLong)
  
  if (Ele (XPoint) NE MissVal) then begin
  	Elev (XLong,XLati) = Ele (XPoint)
  endif else begin
        Elev (XLong,XLati) = MissVal
  endelse
endfor

print, "defined 2D array..."

loadanyct, 4
Black = 0
White = 255
Grey  = 254

ColVec = (findgen (20) * 10)  + 35
ConVec = (findgen (20) * 0.2) - 0.5

set_plot, 'X'
window, /free, xsize=500, ysize=400, xpos=600, title="elevations plot"

scale_vert, levels=ConVec, c_colors=ColVec, noextremes=[" "," "], chwid=2, ytickformat='(f7.1)'

contour, Elev, Long, Lati, levels=ConVec, c_colors=ColVec, /closed, /fill, $
    		xrange=[-20,60], yrange=[30,82], ystyle=1
    
scale_vert, /off

PSPath = ""
print, "  > Enter the filepath of the .eps file: "
read, PSPath

set_plot, 'ps', /copy
device, filename=PSPath, bits_per_pixel=4, /Color, /encapsulated, xsize=5.0, ysize=4.0, /inches

scale_vert, levels=ConVec, c_colors=ColVec, noextremes=[" "," "], chwid=2, ytickformat='(f7.1)'

contour, Elev, Long, Lati, levels=ConVec, c_colors=ColVec, /closed, /fill, $
    		xrange=[-20,60], yrange=[30,82], ystyle=1
    
scale_vert, /off

device, /close
set_plot, 'X'	

while (!D.Window GE 0) do wdelete, !D.Window

end
