loadanyct, 0
Black=0 & White=255 & Grey=254

PSPath = "gobbledegook"
Encaps = 0
print, "  > Enter the PostScript filepath:"
read, PSPath

Set_Plot, 'ps', /copy
device, filename=PSPath, bits_per_pixel=8, /Color, /encapsulated

Data       = fltarr (4,3)
Data [0,*] = [11.00,14.30,22.67]		; Ga temp
Data [1,*] = [06.41,09.53,15.06]		; Ga prec
Data [2,*] = [07.18,08.89,15.92]		; Gd temp
Data [3,*] = [03.95,05.60,09.94]		; Gd prec

Names      = strarr (3)
Names [*]  = ['i','ii','iii']

Vari       = strarr (4)
Vari [*]   = ['Ga temperature','Ga precipitation','Gd temperature','Gd precipitation']

for XGraph = 0, 3 do begin		; loops for each graph
 
  !P.Multi = [(4-XGraph), 2, 2, 0, 0]
  
  plot, [0,0], /nodata, /noerase, yrange=[0,25], xstyle=4, ystyle=9, color=Black, background=White, $
  	ytitle="signal-to-noise ratio", title=Vari[XGraph],font=5
  
  bar_plot, Data[XGraph,*], barnames=Names, colors=[Grey,Grey,Grey],  /overplot

endfor

device, /close

set_plot, 'X'	

end
