pro makevapnorm

stem='/cru/mark1/f080/gts/vap/glo25/glo25.vap.'

for iy=1961,1990 do begin
  loadfile=strip(string(stem,iy))
  rdbin,vapyear,loadfile,gridsize=2.5,/quiet
  
  if iy eq 1961 then begin
    land=where(vapyear gt -9999,nland) & sea=where(vapyear le -9999,nsea)
    print, '2.5deg grid: land,sea: ', nland/12,nsea/12
    vaptot=float(vapyear)*0.0
  endif
  
  weird=where(vapyear(land) eq -9999,nweird)
  if nweird gt 0 then print,'found unexpected missings: ',nweird
  
  rangemax=max(vapyear(land),min=rangemin)
  print,rangemin,rangemax
  
  vaptot(land)=vaptot(land)+vapyear(land)
endfor

vaptot(land)=vaptot(land)/30.0
vaptot(sea)=-9999

rangemax=max(vaptot(land),min=rangemin)
print,rangemin,rangemax
  
savefile='/cru/tyn1/f014/_keep/glo25.vap.6190'
wrbin,fix(round(vaptot)),savefile,/compre

end
