pro makefrsnorm

stem='/cru/mark1/f080/gts/frs/glo25/glo25.frs.'

for iy=1961,1990 do begin
  loadfile=strip(string(stem,iy))
  rdbin,frsyear,loadfile,gridsize=2.5,/quiet
  
  if iy eq 1961 then begin
    land=where(frsyear gt -9999,nland) & sea=where(frsyear le -9999,nsea)
    print, '2.5deg grid: land,sea: ', nland/12,nsea/12
    frstot=float(frsyear)*0.0
  endif
  
  weird=where(frsyear(land) eq -9999,nweird)
  if nweird gt 0 then print,'found unexpected missings: ',nweird
  
  rangemax=max(frsyear(land),min=rangemin)
  print,iy,rangemin,rangemax
  
  frstot(land)=frstot(land)+frsyear(land)
endfor

frstot(land)=frstot(land)/30.0
frstot(sea)=-9999

rangemax=max(frstot(land),min=rangemin)
print,rangemin,rangemax
  
savefile='/cru/tyn1/f014/_keep/glo25.frs.6190'
wrbin,fix(round(frstot)),savefile

end
