<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text"/>


   <xsl:template match="*"/>
   <xsl:template match="/*">
      <xsl:apply-templates />
   </xsl:template>


<!-- DESCRIPTION -->

   <xsl:template match="DESCRIPTION | description">
      <xsl:value-of select="AUTHOR/FIRST-NAME | author/first-name" />
      <xsl:text disable-output-escaping="no">&#032;</xsl:text>

      <xsl:value-of select="AUTHOR/LAST-NAME | author/last-name" />
      <xsl:text disable-output-escaping="no">&#046;&#032;</xsl:text>

      <xsl:text disable-output-escaping="no">&#034;</xsl:text>
      <xsl:value-of select="TITLE | title" />
      <xsl:text disable-output-escaping="no">&#034;&#010;</xsl:text>
   </xsl:template>


<!-- BODY -->
   <xsl:template match="BODY | body">
      <xsl:apply-templates />
   </xsl:template>


<!-- PART and CHAPTER -->

   <xsl:template match="CHAPTER | chapter | PART | part">
       <xsl:text disable-output-escaping="no">&#010;&#010;</xsl:text>
       <xsl:value-of select="@TITLE | @title" />
       <xsl:text disable-output-escaping="no">&#010;&#010;&#010;</xsl:text>
       <xsl:apply-templates />
   </xsl:template>


<!-- EPIGRAPH -->

    <xsl:template match="EPIGRAPH | epigraph">
       <xsl:apply-templates />
       <xsl:text disable-output-escaping="no">&#010;&#010;</xsl:text>
    </xsl:template>


<!-- EPIGRAPH/EPIGRAPHAUTHOR -->

    <xsl:template match="EPIGRAPH/EPIGRAPHAUTHOR | epigraph/epigraphauthor">
       <xsl:text disable-output-escaping="no">&#010;</xsl:text>
       <xsl:apply-templates />
    </xsl:template>


<!-- PARAGRAPH -->

    <xsl:template match="PARAGRAPH | P | paragraph | p">
       <xsl:text disable-output-escaping="no">&#032;&#032;&#032;</xsl:text>
       <xsl:apply-templates />
       <xsl:text disable-output-escaping="no">&#010;</xsl:text>
    </xsl:template>


<!-- EMPTYLINE -->

    <xsl:template match="EMPTYLINE | emptyline">
       <xsl:text disable-output-escaping="no">&#010;</xsl:text>
    </xsl:template>


<!-- EMPHASIS -->

   <xsl:template match="EMPHASIS | emphasis">
      <xsl:text disable-output-escaping="no">&#095;</xsl:text>
      <xsl:apply-templates />
      <xsl:text disable-output-escaping="no">&#095;</xsl:text>
   </xsl:template>


<!-- NOTE -->

    <xsl:template match="NOTE | note">
       <xsl:text disable-output-escaping="no">&#032;&#040;</xsl:text>
       <xsl:apply-templates />
       <xsl:text disable-output-escaping="no">&#041;</xsl:text>

    </xsl:template>


<!-- SUBHEADING -->
    <xsl:template match="SUBHEADING | subheading">
       <xsl:text disable-output-escaping="no">&#010;</xsl:text>
       <xsl:apply-templates />
       <xsl:text disable-output-escaping="no">&#010;&#010;</xsl:text>
    </xsl:template>


</xsl:stylesheet>