<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" version="4.0"/>

   <xsl:template match="*"/>

   <xsl:template match="/">
      <html>
         <head>
            <style>
               body{text-align:justify}
               a{text-decoration: none}
            </style>
         </head>
         <body>
            <h4 align="center">
            <font face="Tahoma">
               <xsl:value-of select="BOOK/DESCRIPTION/TITLE | book/description/title"/>
            </font>
            </h4>
            <!-- <xsl:apply-templates select="//PART | //part | //CHAPTER | //chapter"/>-->
            <xsl:apply-templates select="//BODY | //body" />

         </body>

      </html>
   </xsl:template>
 

<!-- BODY -->
   <xsl:template match="BODY | body">
      <xsl:apply-templates />
   </xsl:template>


<!-- PART and CHAPTER -->

   <xsl:template match="CHAPTER | chapter | PART | part">
       <a href="xml2lit_book#TOC_{generate-id()}">
         <font face="Tahoma">
         <xsl:value-of select="@TITLE | @title" />
         </font>
       </a>
      <br/>
      <xsl:apply-templates />
  </xsl:template>

</xsl:stylesheet>