<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" version="4.0"/>

    <xsl:template match="*"/>

   <xsl:template match="/*">
      <html>
         <head>
            <title>
               <xsl:value-of select="DESCRIPTION/TITLE | description/title"/>
            </title>
            <style>
               body{text-align:justify}
            </style>
         </head>
         <body>
            <xsl:apply-templates select="//NOTE | //note"/>
         </body>
      </html>
   </xsl:template>




<!-- NOTE -->
    <xsl:template match="NOTE | note">
       <p>
       <font face="Tahoma">
       <a href="xml2lit_book#{generate-id()}">
          <sup><xsl:value-of select="@NAME | @name"/></sup>
       </a> 
       <a name="{generate-id()}">
          <xsl:apply-templates /> 
       </a>
       </font>
       </p>
    </xsl:template>

<!-- EMPHASIS -->

    <xsl:template match="EMPHASIS | emphasis">
       <i><xsl:apply-templates /></i>
    </xsl:template>


</xsl:stylesheet>