<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" version="4.0"/>

   <xsl:template match="*"/>

   <xsl:template match="/*">
      <html>
         <head>
            <title>
               <xsl:value-of select="DESCRIPTION/TITLE | description/title"/>
            </title>
            <style>
               body{text-align:justify}
               .pagebreak{page-break-before:always}
            </style>
         </head>
         <body>
            <xsl:apply-templates />
         </body>
      </html>
   </xsl:template>



<!-- DESCRIPTION -->

   <xsl:template match="DESCRIPTION | description">
      <xsl:apply-templates />
   </xsl:template>


<!-- BODY -->

   <xsl:template match="BODY | body">
      <xsl:apply-templates />
   </xsl:template>


<!-- PART and CHAPTER -->

   <xsl:template match="CHAPTER | chapter | PART | part">
      <h4 id="TOC_{generate-id()}">
         <font face="Tahoma">
         <xsl:value-of select="@TITLE | @title" />
         </font>
      </h4>
      <br/>
      <xsl:apply-templates />
  </xsl:template>


<!-- EPIGRAPH -->

    <xsl:template match="EPIGRAPH | epigraph">
       <p align="right"><font face="Tahoma"><xsl:apply-templates /><br/><br/></font></p>
    </xsl:template>


<!-- EPIGRAPH/EPIGRAPHAUTHOR -->

    <xsl:template match="EPIGRAPH/EPIGRAPHAUTHOR | epigraph/epigraphauthor">
       <br/><i><xsl:apply-templates /></i>
    </xsl:template>


<!-- PARAGRAPH -->

    <xsl:template match="PARAGRAPH | P | paragraph | p">
       <p><font face="Tahoma"><xsl:apply-templates /></font></p>
    </xsl:template>


<!-- EMPTYLINE -->

    <xsl:template match="EMPTYLINE | emptyline">
       <br/><br/>
    </xsl:template>


<!-- PAGEBREAK -->

    <xsl:template match="PAGEBREAK | pagebreak">
       <div class="pagebreak"></div>
    </xsl:template>


<!-- EMPHASIS -->

    <xsl:template match="EMPHASIS | emphasis">
       <b><xsl:apply-templates /></b>
    </xsl:template>

<!-- NOTE -->

    <xsl:template match="NOTE | note">
       <a href="xml2lit_notes#{generate-id()}">
          <sup><xsl:value-of select="@NAME | @name"/></sup>
       </a>
       <a name="{generate-id()}">
       </a>
    </xsl:template>


<!-- SUBHEADING -->
    <xsl:template match="SUBHEADING | subheading">
       <h5><font face="Tahoma"><xsl:apply-templates /></font></h5>
    </xsl:template>


<!-- IMAGE -->
    <xsl:template match="IMAGE | image">
       <div align="center">
          <img border="0">
             <xsl:attribute name="src"><xsl:value-of select="@NAME | @name"/></xsl:attribute>
          </img>
       </div>
    </xsl:template>


</xsl:stylesheet>