<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" version="4.0"/>

   <xsl:template match="*"/>

   <xsl:template match="/*">
      <html>
         <head>
            <title>
               <xsl:value-of select="DESCRIPTION/TITLE | description/title"/>
            </title>
            <style>
               body{text-align:justify}
            </style>
         </head>
         <body>
            <xsl:apply-templates />
         </body>
      </html>
   </xsl:template>



<!-- DESCRIPTION -->

   <xsl:template match="DESCRIPTION | description">
      <xsl:apply-templates />
   </xsl:template>

<!-- ANNOTATION -->
   <xsl:template match="ANNOTATION | annotation">
      <xsl:apply-templates />
   </xsl:template>


<!-- PARAGRAPH -->

    <xsl:template match="PARAGRAPH | P | paragraph | p">
       <p><font face="Tahoma"><xsl:apply-templates /></font></p>
    </xsl:template>

<!-- EMPHASIS -->

    <xsl:template match="EMPHASIS | emphasis">
       <i><xsl:apply-templates /></i>
    </xsl:template>

</xsl:stylesheet>