<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html"/>

   <xsl:template match="*"/>

   <xsl:template match="/*">
      <html>
         <head>
            <title>
               <xsl:value-of select="DESCRIPTION/TITLE | description/title"/>
            </title>
            <style>
               body{text-align:justify}
            </style>
         </head>
         <body>
            
            <h3 align="center"><xsl:value-of select="DESCRIPTION/TITLE | description/title"/></h3>

            <!-- BUILD TOC -->
            <xsl:for-each select="//CHAPTER | //chapter | //PART | //part">
               <xsl:call-template name="toc"/>
            </xsl:for-each>

            <!-- BUILD BOOK -->
            <xsl:apply-templates />

            <!-- BUILD NOTES -->
            <xsl:for-each select="//NOTE | //note">
               <xsl:call-template name="note"/>
            </xsl:for-each>

         </body>
      </html>
   </xsl:template>


<!-- TOC TEMPLATE-->

   <xsl:template name="toc">
       <a href="#TOC_{generate-id()}">
         <xsl:value-of select="@TITLE | @title" />
       </a>
      <br/>
  </xsl:template>


<!-- NOTE TEMPLATE-->

   <xsl:template name="note">
       <p>
       <a href="#{generate-id()}">
          <sup><xsl:value-of select="@NAME | @name"/></sup>
       </a> 
       <a name="f_{generate-id()}">
          <xsl:apply-templates /> 
       </a>
       </p>
  </xsl:template>


<!-- DESCRIPTION -->

   <xsl:template match="DESCRIPTION | description">
      <xsl:apply-templates />
   </xsl:template>


<!-- BODY -->

   <xsl:template match="BODY | body">
      <xsl:apply-templates />
   </xsl:template>



<!-- PART and CHAPTER -->

   <xsl:template match="CHAPTER | chapter | PART | part">
      <h4 id="TOC_{generate-id()}">
         <xsl:value-of select="@TITLE | @title" />
      </h4>
      <br/>
      <xsl:apply-templates />
  </xsl:template>


<!-- EPIGRAPH -->

    <xsl:template match="EPIGRAPH | epigraph">
       <p align="right"><xsl:apply-templates /><br/><br/></p>
    </xsl:template>


<!-- EPIGRAPH/EPIGRAPHAUTHOR -->

    <xsl:template match="EPIGRAPH/EPIGRAPHAUTHOR | epigraph/epigraphauthor">
       <br/><i><xsl:apply-templates /></i>
    </xsl:template>


<!-- PARAGRAPH -->

    <xsl:template match="PARAGRAPH | P | paragraph | p">
       <p><xsl:apply-templates /></p>
    </xsl:template>


<!-- EMPTYLINE -->

    <xsl:template match="EMPTYLINE | emptyline">
       <br/><br/>
    </xsl:template>


<!-- PAGEBREAK -->

    <xsl:template match="PAGEBREAK | pagebreak">
       <div class="pagebreak"></div>
    </xsl:template>


<!-- EMPHASIS -->

    <xsl:template match="EMPHASIS | emphasis">
       <b><xsl:apply-templates /></b>
    </xsl:template>

<!-- NOTE -->

    <xsl:template match="NOTE | note">
       <a href="#f_{generate-id()}">
          <sup><xsl:value-of select="@NAME | @name"/></sup>
       </a>
       <a name="{generate-id()}">
       </a>
    </xsl:template>


<!-- SUBHEADING -->
    <xsl:template match="SUBHEADING | subheading">
       <h5><xsl:apply-templates /></h5>
    </xsl:template>


<!-- IMAGE -->
    <xsl:template match="IMAGE | image">
       <div align="center">
          <img border="0">
             <xsl:attribute name="src"><xsl:value-of select="@NAME | @name"/></xsl:attribute>
          </img>
       </div>
    </xsl:template>


</xsl:stylesheet>