#!/usr/local/bin/perl

# Options:
#
# +iso:        convert to ISO 8859-1
# -iso:        convert to entity representation (default)
# +characters: convert characters outside ASCII
# -characters: don't convert characters outside ASCII (default)
# +html:       convert HTML special characters &, ", <, >
# -html:       don't convert HTML special characters &, ", <, > (default)

$characters = "no";
$html = "no";
$iso = "no";
for ($i = 0; $i <= $#ARGV; $i++)
{
    if ($ARGV[$i] =~ /^([+-])(.*)/)
    {
	$c = $1;
	splice (@ARGV, $i, 1);
	$i--;
	$_ = $2;
	{
	    /^c/ && ($characters = ($c eq "+" ? "yes" : "no"), last);
	    /^h/ && ($html       = ($c eq "+" ? "yes" : "no"), last);
	    /^i/ && ($iso        = ($c eq "+" ? "yes" : "no"), last);
	}
    };
};

@html = ('&', '&amp;',		# must be the first one
	 '<', '&lt;',
	 '>', '&gt;',
	 '"', '&quot;');

@characters = ('', '&aacute;',
	       '', '&Aacute;',
	       '', '&acirc;',
	       '', '&Acirc;',
	       '', '&agrave;',
	       '', '&Agrave;',
	       '', '&aring;',
	       '', '&Aring;',
	       '', '&atilde;',
	       '', '&Atilde;',
	       '', '&auml;',
	       '', '&Auml;',
	       '', '&aelig;',
	       '', '&AElig;',
	       '', '&ccedil;',
	       '', '&Ccedil;',
	       '', '&eth;',
	       '', '&ETH;',
	       '', '&eacute;',
	       '', '&Eacute;',
	       '', '&ecirc;',
	       '', '&Ecirc;',
	       '', '&egrave;',
	       '', '&Egrave;',
	       '', '&euml;',
	       '', '&Euml;',
	       '', '&iacute;',
	       '', '&Iacute;',
	       '', '&icirc;',
	       '', '&Icirc;',
	       '', '&igrave;',
	       '', '&Igrave;',
	       '', '&iuml;',
	       '', '&Iuml;',
	       '', '&ntilde;',
	       '', '&Ntilde;',
	       '', '&oacute;',
	       '', '&Oacute;',
	       '', '&ocirc;',
	       '', '&Ocirc;',
	       '', '&ograve;',
	       '', '&Ograve;',
	       '', '&oslash;',
	       '', '&Oslash;',
	       '', '&otilde;',
	       '', '&Otilde;',
	       '', '&ouml;',
	       '', '&Ouml;',
	       '', '&szlig;',
	       '', '&thorn;',
	       '', '&THORN;',
	       '', '&uacute;',
	       '', '&Uacute;',
	       '', '&ucirc;',
	       '', '&Ucirc;',
	       '', '&ugrave;',
	       '', '&Ugrave;',
	       '', '&uuml;',
	       '', '&Uuml;',
	       '', '&yacute;',
	       '', '&Yacute;',
	       '', '&yuml;');

while (<>)
{

    if ($iso eq "no")
    {
	if ($html eq "yes")
	{
	    for ($i = 0; $i <= $#html; $i += 2)
	    {
		s/$html[$i]/$html[$i+1]/eg;
	    };
	};
	
	if ($characters eq "yes")
	{
	    for ($i = 0; $i <= $#characters; $i += 2)
	    {
		s/$characters[$i]/$characters[$i+1]/eg;
	    };
	};
    }
    else
    {
	if ($html eq "yes")
	{
	    for ($i = 1; $i < $#html; $i += 2)
	    {
		s/$html[$i]/$html[$i-1]/eg;
	    };
	};
	
	if ($characters eq "yes")
	{
	    for ($i = 1; $i < $#characters; $i += 2)
	    {
		s/$characters[$i]/$characters[$i-1]/eg;
	    };
	};
    }

    print;
}



